/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplication;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplicationModule;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class AltibaseReplicationReceiver
extends AltibaseReplicationModule {
    private long applyXsn = -1L;
    private long insertSuccessCount = 0L;
    private long insertFailureCount = 0L;
    private long updateSuccessCount = 0L;
    private long updateFailureCount = 0L;
    private long deleteSuccessCount = 0L;
    private long deleteFailureCount = 0L;

    public AltibaseReplicationReceiver(AltibaseReplication parent, JDBCResultSet resultSet) {
        super(parent);
        this.applyXsn = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"APPLY_XSN");
        this.insertSuccessCount = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"INSERT_SUCCESS_COUNT");
        this.insertFailureCount = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"INSERT_FAILURE_COUNT");
        this.updateSuccessCount = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"UPDATE_SUCCESS_COUNT");
        this.updateFailureCount = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"UPDATE_FAILURE_COUNT");
        this.deleteSuccessCount = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"DELETE_SUCCESS_COUNT");
        this.deleteFailureCount = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"DELETE_FAILURE_COUNT");
    }

    @Override
    @Property(viewable=false, order=1, hidden=true)
    @NotNull
    public String getName() {
        return "Receiver";
    }

    @Property(viewable=true, order=3)
    public long getApplyXsn() {
        return this.applyXsn;
    }

    @Property(viewable=true, order=4)
    public long getInsertSuccessCount() {
        return this.insertSuccessCount;
    }

    @Property(viewable=true, order=5)
    public long getInsertFailureCount() {
        return this.insertFailureCount;
    }

    @Property(viewable=true, order=6)
    public long getUpdateSuccessCount() {
        return this.updateSuccessCount;
    }

    @Property(viewable=true, order=7)
    public long getUpdateFailureCount() {
        return this.updateFailureCount;
    }

    @Property(viewable=true, order=8)
    public long getDeleteSuccessCount() {
        return this.deleteSuccessCount;
    }

    @Property(viewable=true, order=9)
    public long getDeleteFailureCount() {
        return this.deleteFailureCount;
    }
}

