/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public class ChangePropertyAction
extends Action
implements IPropertyChangeListener,
DisposeListener {
    private CompareConfiguration fCompareConfiguration;
    private final String fPropertyKey;
    private final ResourceBundle fBundle;
    private final String fPrefix;

    public static ChangePropertyAction createIgnoreWhiteSpaceAction(ResourceBundle bundle, CompareConfiguration compareConfiguration) {
        return new ChangePropertyAction(bundle, compareConfiguration, "action.IgnoreWhiteSpace.", "IGNORE_WHITESPACE");
    }

    public static ChangePropertyAction createShowPseudoConflictsAction(ResourceBundle bundle, CompareConfiguration compareConfiguration) {
        return new ChangePropertyAction(bundle, compareConfiguration, "action.ShowPseudoConflicts.", "SHOW_PSEUDO_CONFLICTS");
    }

    public ChangePropertyAction(ResourceBundle bundle, CompareConfiguration cc, String rkey, String pkey) {
        this.fPropertyKey = pkey;
        this.fBundle = bundle;
        this.fPrefix = rkey;
        Utilities.initAction((IAction)this, this.fBundle, this.fPrefix);
        this.setCompareConfiguration(cc);
    }

    public void run() {
        boolean b = !Utilities.getBoolean(this.fCompareConfiguration, this.fPropertyKey, false);
        this.setChecked(b);
        if (this.fCompareConfiguration != null) {
            this.fCompareConfiguration.setProperty(this.fPropertyKey, b);
        }
    }

    public void setChecked(boolean state) {
        super.setChecked(state);
        Utilities.initToggleAction((IAction)this, this.fBundle, this.fPrefix, state);
    }

    public void setCompareConfiguration(CompareConfiguration cc) {
        if (this.fCompareConfiguration != null) {
            this.fCompareConfiguration.removePropertyChangeListener(this);
        }
        this.fCompareConfiguration = cc;
        if (this.fCompareConfiguration != null) {
            this.fCompareConfiguration.addPropertyChangeListener(this);
        }
        this.setChecked(Utilities.getBoolean(this.fCompareConfiguration, this.fPropertyKey, false));
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(this.fPropertyKey)) {
            this.setChecked(Utilities.getBoolean(this.fCompareConfiguration, this.fPropertyKey, false));
        }
    }

    public void dispose() {
        if (this.fCompareConfiguration != null) {
            this.fCompareConfiguration.removePropertyChangeListener(this);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }
}

