/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.ExasolUserType;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolPriority;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolUser;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class ExasolUserManager
extends SQLObjectEditor<ExasolUser, ExasolDataSource>
implements DBEObjectRenamer<ExasolUser> {
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<ExasolDataSource, ExasolUser> getObjectsCache(ExasolUser object) {
        ExasolDataSource ds = object.getDataSource();
        return ds.getUserCache();
    }

    protected ExasolUser createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        return new ExasolUser((ExasolDataSource)((Object)container), "user", "", "", "password", "", ExasolUserType.LOCAL);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        ExasolUser obj = (ExasolUser)command.getObject();
        StringBuilder script = new StringBuilder("CREATE USER " + DBUtils.getQuotedIdentifier((DBSObject)obj) + " IDENTIFIED ");
        switch (obj.getType()) {
            case LOCAL: {
                script.append(" BY \"" + obj.getPassword() + "\"");
                break;
            }
            case LDAP: {
                script.append(" AT LDAP AS '" + obj.getDn() + "'");
                break;
            }
            default: {
                script.append(" BY KERBEROS PRINCIPAL '" + obj.getKerberosPrincipal() + "'");
            }
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create User", script.toString()));
        if (!CommonUtils.isEmpty((String)obj.getDescription())) {
            actions.add((DBEPersistAction)this.Comment(obj));
        }
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        ExasolUser obj = (ExasolUser)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop User", "DROP USER " + DBUtils.getQuotedIdentifier((DBSObject)obj)));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull ExasolUser object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    protected void processObjectRename(DBECommandContext commandContext, ExasolUser object, Map<String, Object> options, String newName) throws DBException {
        SQLObjectEditor.ObjectRenameCommand command = new SQLObjectEditor.ObjectRenameCommand((SQLObjectEditor)this, (DBSObject)object, ModelMessages.model_jdbc_rename_object, options, newName);
        commandContext.addCommand((DBECommand)command, (DBECommandReflector)new SQLObjectEditor.RenameObjectReflector((SQLObjectEditor)this), true);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        ExasolUser obj = (ExasolUser)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename User", "RENAME USER " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getNewName())));
    }

    private SQLDatabasePersistAction Comment(ExasolUser obj) {
        return new SQLDatabasePersistAction("Comment on User", "COMMENT ON USER " + DBUtils.getQuotedIdentifier((DBSObject)obj) + " IS '" + ExasolUtils.quoteString(obj.getDescription()) + "'");
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        CharSequence script;
        ExasolUser obj = (ExasolUser)command.getObject();
        if (command.getProperties().containsKey("description")) {
            actionList.add((DBEPersistAction)this.Comment(obj));
        }
        if (command.getProperties().containsKey("priority")) {
            String script2;
            ExasolPriority priority = obj.getPriority();
            if ("org.jkiss.dbeaver.ext.exasol.model.ExasolPriorityGroup".equals(priority.getClass().getName())) {
                script2 = String.format("GRANT PRIORITY GROUP %s to %s", DBUtils.getQuotedIdentifier((DBSObject)priority), DBUtils.getQuotedIdentifier((DBSObject)obj));
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_assign_priority_group, script2));
            }
            if ("org.jkiss.dbeaver.ext.exasol.model.ExasolConsumerGroup".equals(priority.getClass().getName())) {
                script2 = String.format("ALTER USER  %s SET CONSUMER_GROUP = %s", DBUtils.getQuotedIdentifier((DBSObject)obj), DBUtils.getQuotedIdentifier((DBSObject)priority));
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_assign_priority_group, script2));
            }
        }
        if (command.getProperties().containsKey("dn")) {
            script = String.format("ALTER USER " + DBUtils.getQuotedIdentifier((DBSObject)obj) + " IDENTIFIED AT LDAP AS '%s'", obj.getDn());
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("alter user", (String)script));
            return;
        }
        if (command.getProperties().containsKey("kerberosPrincipal")) {
            script = String.format("ALTER USER " + DBUtils.getQuotedIdentifier((DBSObject)obj) + " IDENTIFIED BY KERBEROS PRINCIPAL '%s'", obj.getKerberosPrincipal());
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("alter user", (String)script));
            return;
        }
        if (command.getProperties().containsKey("password")) {
            script = new StringBuilder("ALTER USER " + DBUtils.getQuotedIdentifier((DBSObject)obj) + " IDENTIFIED ");
            ((StringBuilder)script).append(" BY \"" + obj.getPassword() + "\" ");
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Modify User", ((StringBuilder)script).toString()));
        }
    }
}

