/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiValueMap<U, V> {
    private final Map<U, List<V>> map = new HashMap<U, List<V>>();

    public List<V> get(Object key) {
        return this.map.get(key);
    }

    public void put(U key, V value) {
        List values = this.map.computeIfAbsent(key, ignored -> new ArrayList(1));
        if (!values.contains(value)) {
            values.add(value);
        }
    }

    public int remove(U key, V value) {
        List<V> values = this.map.get(key);
        if (values != null) {
            int position = values.indexOf(value);
            if (position == -1) {
                return -1;
            }
            values.remove(position);
            if (values.isEmpty()) {
                this.map.remove(key);
            }
            return position;
        }
        return -1;
    }

    public V removeValue(V value) {
        Iterator<List<V>> iter = this.map.values().iterator();
        while (iter.hasNext()) {
            List<V> current = iter.next();
            if (!current.remove(value)) continue;
            if (current.isEmpty()) {
                iter.remove();
            }
            return value;
        }
        return null;
    }

    public int size() {
        return this.map.size();
    }
}

