/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.LocalOptimizer;
import org.eclipse.draw2d.graph.NestingTree;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.RankSorter;
import org.eclipse.draw2d.graph.Subgraph;

class CompoundRankSorter
extends RankSorter {
    boolean init;
    Map<RowKey, RowEntry> map = new HashMap<RowKey, RowEntry>();

    CompoundRankSorter() {
    }

    void addRowEntry(Subgraph s, int row) {
        this.map.computeIfAbsent(new RowKey(row, s), k -> new RowEntry());
    }

    @Override
    protected void assignIncomingSortValues() {
        super.assignIncomingSortValues();
    }

    @Override
    protected void assignOutgoingSortValues() {
        super.assignOutgoingSortValues();
    }

    @Override
    void optimize(DirectedGraph g) {
        CompoundDirectedGraph graph = (CompoundDirectedGraph)g;
        graph.containment.forEach(graph::removeEdge);
        graph.containment.clear();
        new LocalOptimizer().visit(graph);
    }

    @Override
    double evaluateNodeOutgoing() {
        double result = super.evaluateNodeOutgoing();
        if (this.progress > 0.2) {
            double connectivity;
            Subgraph s = this.node.getParent();
            result = connectivity = this.mergeConnectivity(s, this.node.rank + 1, result, this.progress);
        }
        return result;
    }

    @Override
    double evaluateNodeIncoming() {
        double result = super.evaluateNodeIncoming();
        if (this.progress > 0.2) {
            double connectivity;
            Subgraph s = this.node.getParent();
            result = connectivity = this.mergeConnectivity(s, this.node.rank - 1, result, this.progress);
        }
        return result;
    }

    double mergeConnectivity(Subgraph s, int row, double result, double scaleFactor) {
        while (s != null && this.getRowEntry(s, row) == null) {
            s = s.getParent();
        }
        if (s != null) {
            RowEntry entry = this.getRowEntry(s, row);
            double connectivity = entry.contribution / (double)entry.count;
            result = connectivity * 0.3 + 0.7 * result;
        }
        return result;
    }

    RowEntry getRowEntry(Subgraph s, int row) {
        return this.map.get(new RowKey(row, s));
    }

    void copyConstraints(NestingTree tree) {
        if (tree.subgraph != null) {
            tree.sortValue = tree.subgraph.getRowConstraint();
        }
        for (Object child : tree.contents) {
            if (child instanceof Node) {
                Node n = (Node)child;
                n.sortValue = n.getRowConstraint();
                continue;
            }
            this.copyConstraints((NestingTree)child);
        }
    }

    @Override
    public void init(DirectedGraph g) {
        super.init(g);
        this.init = true;
        int row = 0;
        while (row < g.ranks.size()) {
            Rank rank = g.ranks.getRank(row);
            NestingTree tree = NestingTree.buildNestingTreeForRank(rank);
            this.copyConstraints(tree);
            tree.recursiveSort(true);
            rank.clear();
            tree.repopulateRank(rank);
            for (Node n : rank) {
                Subgraph s = n.getParent();
                while (s != null) {
                    this.addRowEntry(s, row);
                    s = s.getParent();
                }
            }
            ++row;
        }
    }

    @Override
    protected void postSort() {
        super.postSort();
        if (this.init) {
            this.updateRank(this.rank);
        }
    }

    void updateRank(Rank rank) {
        Subgraph s;
        for (Node n : rank) {
            s = n.getParent();
            while (s != null) {
                this.getRowEntry(s, this.currentRow).reset();
                s = s.getParent();
            }
        }
        for (Node n : rank) {
            s = n.getParent();
            while (s != null) {
                RowEntry entry = this.getRowEntry(s, this.currentRow);
                ++entry.count;
                entry.contribution += (double)n.index;
                s = s.getParent();
            }
        }
    }

    static class RowEntry {
        double contribution;
        int count;

        RowEntry() {
        }

        void reset() {
            this.count = 0;
            this.contribution = 0.0;
        }
    }

    record RowKey(int rank, Subgraph s) {
    }
}

