/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.text.MessageFormat;
import org.eclipse.draw2d.AbstractConstraintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.internal.Logger;
import org.eclipse.draw2d.internal.Messages;

public class XYLayout
extends AbstractConstraintLayout {
    private static final Logger LOGGER = Logger.getLogger(XYLayout.class);

    @Override
    protected Dimension calculatePreferredSize(IFigure f, int wHint, int hHint) {
        Rectangle rect = new Rectangle();
        for (IFigure iFigure : f.getChildren()) {
            Rectangle r = (Rectangle)this.getConstraint(iFigure);
            if (r == null) continue;
            if (r.width == -1 || r.height == -1) {
                Dimension preferredSize = iFigure.getPreferredSize(r.width, r.height);
                r = r.getCopy();
                if (r.width == -1) {
                    r.width = preferredSize.width;
                }
                if (r.height == -1) {
                    r.height = preferredSize.height;
                }
            }
            rect.union(r);
        }
        Dimension dimension = rect.getSize();
        Insets insets = f.getInsets();
        return new Dimension(dimension.width + insets.getWidth(), dimension.height + insets.getHeight()).union(this.getBorderPreferredSize(f));
    }

    public Point getOrigin(IFigure parent) {
        return parent.getClientArea().getLocation();
    }

    @Override
    public void layout(IFigure parent) {
        Point offset = this.getOrigin(parent);
        for (IFigure iFigure : parent.getChildren()) {
            Rectangle bounds = (Rectangle)this.getConstraint(iFigure);
            if (bounds == null) continue;
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension preferredSize = iFigure.getPreferredSize(bounds.width, bounds.height);
                bounds = bounds.getCopy();
                if (bounds.width == -1) {
                    bounds.width = preferredSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = preferredSize.height;
                }
            }
            bounds = bounds.getTranslated(offset);
            iFigure.setBounds(bounds);
        }
    }

    @Override
    public void setConstraint(IFigure figure, Object newConstraint) {
        if (newConstraint != null && !(newConstraint instanceof Rectangle)) {
            LOGGER.warn(MessageFormat.format(Messages.LayoutManager_InvalidConstraint, this.getClass().getSimpleName(), newConstraint.getClass().getSimpleName(), Rectangle.class.getSimpleName()));
        }
        super.setConstraint(figure, newConstraint);
    }
}

