/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.File;
import java.io.IOException;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.SimpleBackupStore;

public class LazyBackupStore
implements IBackupStore {
    private SimpleBackupStore delegate;
    private final String prefix;

    public LazyBackupStore(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public boolean backup(File file) throws IOException {
        this.loadDelegate();
        return this.delegate.backup(file);
    }

    @Override
    public boolean backupDirectory(File file) throws IOException {
        this.loadDelegate();
        return this.delegate.backupDirectory(file);
    }

    @Override
    public void discard() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.discard();
    }

    @Override
    public void restore() throws IOException {
        if (this.delegate == null) {
            return;
        }
        this.delegate.restore();
    }

    private void loadDelegate() {
        if (this.delegate != null) {
            return;
        }
        this.delegate = new SimpleBackupStore(null, this.prefix);
    }

    @Override
    public String getBackupName() {
        this.loadDelegate();
        return this.delegate.getBackupName();
    }

    @Override
    public boolean backupCopy(File file) throws IOException {
        this.loadDelegate();
        return this.delegate.backupCopy(file);
    }

    @Override
    public void backupCopyAll(File file) throws IOException {
        this.loadDelegate();
        this.delegate.backupCopyAll(file);
    }

    @Override
    public void backupAll(File file) throws IOException {
        this.loadDelegate();
        this.delegate.backupAll(file);
    }
}

