/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;

public class WSClientUtils {
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";

    @Nullable
    public static List<String> getHeaders(@Nullable Map<String, List<String>> allHeaders, @NotNull String headerName) {
        if (allHeaders == null) {
            return null;
        }
        List<String> headerValues = allHeaders.get(headerName);
        if (headerValues == null) {
            headerValues = allHeaders.get(headerName.toLowerCase());
        }
        return headerValues;
    }

    @NotNull
    public static ProxyInfo findProxyInfo() {
        int port;
        String host = System.getProperty(HTTP_PROXY_HOST);
        if (CommonUtils.isEmpty(host)) {
            host = System.getProperty(HTTPS_PROXY_HOST);
        }
        if ((port = CommonUtils.toInt(System.getProperty(HTTP_PROXY_PORT), -1)) < 0) {
            port = CommonUtils.toInt(System.getProperty(HTTPS_PROXY_PORT), -1);
        }
        return new ProxyInfo(host, port);
    }

    public static class ProxyInfo {
        @Nullable
        private final String host;
        private final int port;

        public ProxyInfo(@Nullable String host, int port) {
            this.host = host;
            this.port = port;
        }

        @Nullable
        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean exists() {
            return CommonUtils.isNotEmpty(this.host) && this.port >= 0;
        }
    }
}

