/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation;

import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.transformation.GeoTransformation;
import org.cts.op.transformation.GeocentricTransformation;
import org.cts.op.transformation.ParamBasedTransformation;

public class GeocentricTranslation
extends AbstractCoordinateOperation
implements GeoTransformation,
ParamBasedTransformation {
    private static final Identifier opId = new Identifier("EPSG", "9603", "Geocentric translation", "Translation");
    private double tx;
    private double ty;
    private double tz;
    private GeocentricTranslation inverse;

    public GeocentricTranslation(double tx, double ty, double tz, double precision) {
        super(opId);
        this.tx = tx;
        this.ty = ty;
        this.tz = tz;
        this.precision = Math.min(1.0, precision);
    }

    public GeocentricTranslation(double tx, double ty, double tz) {
        this(tx, ty, tz, 1.0);
    }

    @Override
    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord.length < 3) {
            throw new CoordinateDimensionException(coord, 3);
        }
        coord[0] = this.tx + coord[0];
        coord[1] = this.ty + coord[1];
        coord[2] = this.tz + coord[2];
        return coord;
    }

    @Override
    public GeocentricTransformation inverse() {
        if (this.inverse != null) {
            return this.inverse;
        }
        this.inverse = new GeocentricTranslation(-this.tx, -this.ty, -this.tz, this.precision);
        return this.inverse;
    }

    @Override
    public String toString() {
        return "Geocentric translation (dX=" + (this.tx < 0.0 ? "" : "+") + this.tx + "m, dY=" + (this.ty < 0.0 ? "" : "+") + this.ty + "m, dZ=" + (this.tz < 0.0 ? "" : "+") + this.tz + "m) precision = " + this.precision;
    }

    @Override
    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append(",TOWGS84[");
        if (Math.abs(this.tx - Math.rint(this.tx)) < 1.0E-9) {
            w.append((int)this.tx);
        } else {
            w.append(this.tx);
        }
        w.append(',');
        if (Math.abs(this.ty - Math.rint(this.ty)) < 1.0E-9) {
            w.append((int)this.ty);
        } else {
            w.append(this.ty);
        }
        w.append(',');
        if (Math.abs(this.tz - Math.rint(this.tz)) < 1.0E-9) {
            w.append((int)this.tz);
        } else {
            w.append(this.tz);
        }
        w.append(",0,0,0,0]");
        return w.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CoordinateOperation) {
            if (this.isIdentity() && ((CoordinateOperation)o).isIdentity()) {
                return true;
            }
            if (o instanceof GeocentricTranslation) {
                GeocentricTranslation gt = (GeocentricTranslation)o;
                return this.tx == gt.tx && this.ty == gt.ty && this.tz == gt.tz;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.isIdentity()) {
            return 0;
        }
        int hash = 5;
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.tx) ^ Double.doubleToLongBits(this.tx) >>> 32);
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.ty) ^ Double.doubleToLongBits(this.ty) >>> 32);
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.tz) ^ Double.doubleToLongBits(this.tz) >>> 32);
        return hash;
    }

    @Override
    public boolean isIdentity() {
        return this.tx == 0.0 && this.ty == 0.0 && this.tz == 0.0;
    }
}

