/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.Polygon;
import org.cugos.wkg.Surface;

public class PolyHedralSurface
extends Surface {
    private final List<Polygon> polygons;

    public PolyHedralSurface(List<Polygon> polygons, Dimension dimension, String srid) {
        super(dimension, srid);
        this.polygons = Collections.unmodifiableList(polygons);
    }

    public List<Polygon> getPolygons() {
        return this.polygons;
    }

    @Override
    public boolean isEmpty() {
        return this.polygons.isEmpty();
    }

    @Override
    public int getNumberOfCoordinates() {
        int numberOfCoordinates = 0;
        for (Polygon polygon : this.polygons) {
            numberOfCoordinates += polygon.getNumberOfCoordinates();
        }
        return numberOfCoordinates;
    }

    @Override
    public List<Coordinate> getCoordinates() {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (Polygon polygon : this.polygons) {
            coordinates.addAll(polygon.getCoordinates());
        }
        return Collections.unmodifiableList(coordinates);
    }

    public static PolyHedralSurface createEmpty() {
        return new PolyHedralSurface(new ArrayList<Polygon>(), Dimension.Two, null);
    }
}

