/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.editors.erd.ERDColors;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDThemeSettings;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDViewStyle;
import org.jkiss.dbeaver.ui.editors.erd.figures.AttributeItemFigure;
import org.jkiss.dbeaver.ui.editors.erd.figures.AttributeListFigure;
import org.jkiss.dbeaver.ui.editors.erd.figures.EditableLabel;
import org.jkiss.dbeaver.ui.editors.erd.internal.ERDUIActivator;
import org.jkiss.dbeaver.ui.editors.erd.part.EntityPart;
import org.jkiss.utils.CommonUtils;

public class EntityFigure
extends Figure {
    private final EntityPart part;
    private AttributeListFigure keyFigure;
    private AttributeListFigure attributeFigure;
    private EditableLabel nameLabel;
    private Label descLabel;

    public EntityFigure(EntityPart part) {
        Object entityName;
        this.part = part;
        ERDEntity entity = part.getEntity();
        boolean useFQN = part.getDiagram().hasAttributeStyle(ERDViewStyle.ENTITY_FQN);
        boolean showComments = part.getDiagram().hasAttributeStyle(ERDViewStyle.COMMENTS);
        Image tableImage = DBeaverIcons.getImage((DBPImage)((DBSEntity)entity.getObject()).getEntityType().getIcon());
        this.keyFigure = new AttributeListFigure(entity, true);
        this.attributeFigure = new AttributeListFigure(entity, false);
        Object object = entityName = useFQN ? DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)entity.getObject()), (DBPEvaluationContext)DBPEvaluationContext.DDL) : ((DBSEntity)entity.getObject()).getName();
        if (!CommonUtils.isEmpty((String)entity.getAlias())) {
            entityName = (String)entityName + " " + entity.getAlias();
        }
        this.nameLabel = new EditableLabel((String)entityName){

            public IFigure getToolTip() {
                return null;
            }
        };
        this.nameLabel.setIcon(tableImage);
        this.nameLabel.setBorder((Border)new MarginBorder(3));
        this.descLabel = null;
        if (showComments && !CommonUtils.isEmpty((String)((DBSEntity)entity.getObject()).getDescription())) {
            this.descLabel = new Label(((DBSEntity)entity.getObject()).getDescription());
        }
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.setLayoutManager((LayoutManager)layout);
        LineBorder border = new LineBorder(this.getBorderColor(), 2);
        this.setBorder((Border)border);
        this.setOpaque(true);
        this.add((IFigure)this.nameLabel, new GridData(768));
        if (this.descLabel != null) {
            this.add((IFigure)this.descLabel, new GridData(768));
        }
        this.add((IFigure)this.keyFigure, new GridData(768));
        this.add((IFigure)this.attributeFigure, new GridData(1808));
        this.refreshColors();
    }

    @NotNull
    private IFigure createToolTip() {
        ERDEntity entity = this.part.getEntity();
        DBPDataSourceContainer dataSource = entity.getDataSource().getContainer();
        Figure toolTip = new Figure();
        toolTip.setOpaque(true);
        toolTip.setBorder(this.getBorder());
        toolTip.setLayoutManager((LayoutManager)new GridLayout(1, false));
        Label dsLabel = new Label(dataSource.getName());
        dsLabel.setIcon(DBeaverIcons.getImage((DBPImage)dataSource.getDriver().getIcon()));
        dsLabel.setBorder((Border)new MarginBorder(2));
        toolTip.add((IFigure)dsLabel);
        Label entityLabel = new Label(DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)entity.getObject()), (DBPEvaluationContext)DBPEvaluationContext.UI));
        entityLabel.setIcon(DBeaverIcons.getImage((DBPImage)((DBSEntity)entity.getObject()).getEntityType().getIcon()));
        entityLabel.setBorder((Border)new MarginBorder(2));
        toolTip.add((IFigure)entityLabel);
        return toolTip;
    }

    protected Color getBorderColor() {
        int dsIndex = this.getPart().getDiagram().getDataSourceIndex(this.part.getEntity().getDataSource().getContainer());
        boolean changeBorderColors = ERDUIActivator.getDefault().getPreferenceStore().getBoolean("erd.diagram.change.borders.colors");
        if (dsIndex == 0 || !changeBorderColors) {
            return ERDThemeSettings.instance.linesForeground;
        }
        return ERDColors.getBorderColor(dsIndex - 1);
    }

    public EntityPart getPart() {
        return this.part;
    }

    public void refreshColors() {
        this.setForegroundColor(ERDThemeSettings.instance.entityNameForeground);
        if (this.part.getEntity().isPrimary()) {
            this.setBackgroundColor(ERDThemeSettings.instance.entityPrimaryBackground);
        } else if (((DBSEntity)this.part.getEntity().getObject()).getEntityType() == DBSEntityType.ASSOCIATION) {
            this.setBackgroundColor(ERDThemeSettings.instance.entityAssociationBackground);
        } else {
            boolean changeHeaderColors = ERDUIActivator.getDefault().getPreferenceStore().getBoolean("erd.diagram.change.header.colors");
            if (changeHeaderColors) {
                this.changeHeaderColor();
            } else {
                this.setBackgroundColor(ERDThemeSettings.instance.entityRegularBackground);
            }
        }
    }

    private void changeHeaderColor() {
        DBSObjectContainer container = (DBSObjectContainer)DBUtils.getParentOfType(DBSObjectContainer.class, (DBSObject)((DBSObject)this.part.getEntity().getObject()));
        if (container != null) {
            DBPDataSourceContainer dataSourceContainer = container.getDataSource().getContainer();
            if (dataSourceContainer != null) {
                int containerIndex = this.part.getDiagram().getContainerIndex(dataSourceContainer, container);
                if (containerIndex == 0) {
                    this.setBackgroundColor(ERDThemeSettings.instance.entityRegularBackground);
                } else {
                    this.setBackgroundColor(ERDColors.getHeaderColor(containerIndex - 1));
                }
            } else {
                this.setBackgroundColor(ERDThemeSettings.instance.entityRegularBackground);
            }
        } else {
            this.setBackgroundColor(ERDThemeSettings.instance.entityRegularBackground);
        }
    }

    private void updateTitleForegroundColor() {
        Color bgColor = this.getBackgroundColor();
        if (bgColor == null) {
            this.nameLabel.setForegroundColor(ERDThemeSettings.instance.entityNameForeground);
            if (this.descLabel != null) {
                this.descLabel.setForegroundColor(ERDThemeSettings.instance.entityNameForeground);
            }
        } else {
            this.nameLabel.setForegroundColor(UIStyles.getContrastColor((Color)bgColor));
            if (this.descLabel != null) {
                this.descLabel.setForegroundColor(UIStyles.getContrastColor((Color)bgColor));
            }
        }
    }

    public void setBackgroundColor(Color bg) {
        super.setBackgroundColor(bg);
        this.updateTitleForegroundColor();
    }

    public void setSelected(boolean isSelected) {
        LineBorder lineBorder = (LineBorder)this.getBorder();
        if (isSelected) {
            lineBorder.setWidth(3);
        } else {
            lineBorder.setWidth(2);
        }
    }

    public EditableLabel getNameLabel() {
        return this.nameLabel;
    }

    public AttributeListFigure getKeyFigure() {
        return this.keyFigure;
    }

    public AttributeListFigure getColumnsFigure() {
        return this.attributeFigure;
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (figure instanceof AttributeItemFigure) {
            AttributeItemFigure attributeItemFigure = (AttributeItemFigure)figure;
            figure.setForegroundColor(ERDThemeSettings.instance.attrForeground);
            figure.setBackgroundColor(ERDThemeSettings.instance.attrBackground);
            IFigure attrExtra = this.createRightPanel();
            attributeItemFigure.setRightPanel(attrExtra);
            if (attributeItemFigure.getAttribute().isInPrimaryKey()) {
                this.keyFigure.add(figure, new GridData(32, 2, true, false));
                this.keyFigure.add(attrExtra, new GridData(130));
            } else {
                this.attributeFigure.add(figure, new GridData(32, 2, true, false));
                this.attributeFigure.add(attrExtra, new GridData(130));
            }
        } else {
            super.add(figure, constraint, index);
        }
    }

    protected IFigure createRightPanel() {
        EditableLabel label = new EditableLabel("");
        label.setTextAlignment(4);
        return label;
    }

    public List<AttributeItemFigure> getAttributeFigures() {
        ArrayList<AttributeItemFigure> result = new ArrayList<AttributeItemFigure>();
        result.addAll(this.keyFigure.getAttributes());
        result.addAll(this.attributeFigure.getAttributes());
        return result;
    }

    public void remove(IFigure figure) {
        if (figure instanceof AttributeItemFigure) {
            AttributeItemFigure attrFigure = (AttributeItemFigure)figure;
            AttributeListFigure listFigure = this.keyFigure.getAttributes().contains(figure) ? this.keyFigure : this.attributeFigure;
            listFigure.remove((IFigure)attrFigure);
            if (attrFigure.getRightPanel() != null) {
                listFigure.remove(attrFigure.getRightPanel());
            }
            this.revalidate();
        } else {
            super.remove(figure);
        }
    }
}

