/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteTemplateEntry;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class CopyTemplateAction
extends WorkbenchPartAction
implements ISelectionChangedListener {
    private Object template;

    public CopyTemplateAction(IEditorPart editor) {
        super((IWorkbenchPart)editor);
        this.setId(ActionFactory.COPY.getId());
        this.setText(GEFMessages.CopyAction_Label);
    }

    @Override
    protected boolean calculateEnabled() {
        return this.template != null;
    }

    @Override
    public void dispose() {
        this.template = null;
    }

    public void run() {
        Clipboard.getDefault().setContents(this.template);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        ISelection iSelection = event.getSelection();
        if (iSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)iSelection).size() == 1) {
            this.template = null;
            Object obj = selection.getFirstElement();
            if (obj instanceof EditPart) {
                EditPart ep = (EditPart)obj;
                Object object = ep.getModel();
                if (object instanceof CombinedTemplateCreationEntry) {
                    CombinedTemplateCreationEntry combinedCreationEntry = (CombinedTemplateCreationEntry)object;
                    this.template = combinedCreationEntry.getTemplate();
                } else {
                    Object object2 = ep.getModel();
                    if (object2 instanceof PaletteTemplateEntry) {
                        PaletteTemplateEntry paletteEntry = (PaletteTemplateEntry)object2;
                        this.template = paletteEntry.getTemplate();
                    }
                }
            }
        }
        this.refresh();
    }
}

