/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.RemediationPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateWizard;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class ProvisioningOperationWizard
extends Wizard {
    private static final String WIZARD_SETTINGS_SECTION = "WizardSettings";
    protected ProvisioningUI ui;
    protected IUElementListRoot root;
    protected ProfileChangeOperation operation;
    protected Object[] planSelections;
    protected RemediationPage remediationPage;
    protected ISelectableIUsPage mainPage;
    protected IResolutionErrorReportingPage errorPage;
    protected ResolutionResultsWizardPage resolutionPage;
    private ProvisioningContext provisioningContext;
    protected LoadMetadataRepositoryJob repoPreloadJob;
    IStatus couldNotResolveStatus = Status.OK_STATUS;
    boolean resolveWithRelaxedConstraints = false;
    boolean waitingForOtherJobs = false;
    protected RemediationOperation remediationOperation;
    private IProvisioningPlan localJRECheckPlan;

    public ProvisioningOperationWizard(ProvisioningUI ui, ProfileChangeOperation operation, Object[] initialSelections, LoadMetadataRepositoryJob job) {
        this.ui = ui;
        this.operation = operation;
        this.initializeResolutionModelElements(initialSelections);
        this.repoPreloadJob = job;
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        if (operation != null) {
            this.provisioningContext = operation.getProvisioningContext();
        }
    }

    public void setRemediationOperation(RemediationOperation remediationOperation) {
        this.remediationOperation = remediationOperation;
    }

    public RemediationOperation getRemediationOperation() {
        return this.remediationOperation;
    }

    public void addPages() {
        this.mainPage = this.createMainPage(this.root, this.planSelections);
        this.addPage(this.mainPage);
        this.errorPage = this.createErrorReportingPage();
        if (this.errorPage != this.mainPage) {
            this.addPage(this.errorPage);
        }
        this.remediationPage = this.createRemediationPage();
        if (this.remediationPage != null) {
            this.addPage((IWizardPage)this.remediationPage);
        }
        this.resolutionPage = this.createResolutionPage();
        this.addPage((IWizardPage)this.resolutionPage);
    }

    protected abstract RemediationPage createRemediationPage();

    protected abstract IResolutionErrorReportingPage createErrorReportingPage();

    protected abstract ISelectableIUsPage createMainPage(IUElementListRoot var1, Object[] var2);

    protected abstract ResolutionResultsWizardPage createResolutionPage();

    public boolean performFinish() {
        return this.resolutionPage.performFinish();
    }

    protected LoadMetadataRepositoryJob getRepositoryPreloadJob() {
        return this.repoPreloadJob;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.errorPage) {
            return this.mainPage;
        }
        return super.getPreviousPage(page);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.remediationPage) {
            try {
                this.getContainer().run(true, true, monitor -> {
                    this.remediationOperation.setCurrentRemedy(this.remediationPage.getRemediationGroup().getCurrentRemedy());
                    this.remediationOperation.resolveModal(monitor);
                    if (this.getPolicy().getCheckAgainstCurrentExecutionEnvironment()) {
                        this.localJRECheckPlan = ProvUI.toCompabilityWithCurrentJREProvisioningPlan((ProfileChangeOperation)this.remediationOperation, monitor);
                        if (!this.compatibleWithCurrentEE()) {
                            this.couldNotResolveStatus = this.localJRECheckPlan.getStatus();
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                ProvUI.handleException(e.getCause(), null, 3);
                this.couldNotResolve(null);
            }
            this.operation = this.remediationOperation;
            this.initializeResolutionModelElements(ElementUtils.requestToElement(((RemediationOperation)this.operation).getCurrentRemedy(), !(this instanceof UpdateWizard)));
            this.planChanged();
            if (this.getPolicy().getCheckAgainstCurrentExecutionEnvironment() && !this.compatibleWithCurrentEE()) {
                return this.errorPage;
            }
            return this.resolutionPage;
        }
        if (page == this.mainPage || page == this.errorPage) {
            ISelectableIUsPage currentPage = (ISelectableIUsPage)page;
            if (this.operation == null || this.operation != null && this.shouldRecomputePlan(currentPage)) {
                this.recomputePlan((IRunnableContext)this.getContainer(), true);
            } else {
                this.initializeResolutionModelElements(this.planSelections);
            }
            IStatus status = this.operation.getResolutionResult();
            if (this.getPolicy().getCheckAgainstCurrentExecutionEnvironment() && !this.compatibleWithCurrentEE()) {
                return this.errorPage;
            }
            if (status == null || status.getSeverity() == 4) {
                if (page == this.mainPage) {
                    if (this.remediationOperation != null && this.remediationOperation.getResolutionResult() == Status.OK_STATUS && this.remediationOperation.getRemedyConfigs().length == 1) {
                        this.planChanged();
                        return this.getNextPage((IWizardPage)this.remediationPage);
                    }
                    if (this.remediationOperation != null && this.remediationOperation.getResolutionResult() == Status.OK_STATUS) {
                        this.planChanged();
                        return this.remediationPage;
                    }
                    return this.errorPage;
                }
            } else {
                if (status.getSeverity() == 8) {
                    return page;
                }
                if (this.remediationPage != null) {
                    this.remediationPage.setPageComplete(true);
                }
                return this.resolutionPage;
            }
        }
        return super.getNextPage(page);
    }

    private boolean compatibleWithCurrentEE() {
        if (this.operation == null || !this.getPolicy().getCheckAgainstCurrentExecutionEnvironment()) {
            return true;
        }
        if (this.localJRECheckPlan == null) {
            try {
                this.getContainer().run(true, true, monitor -> {
                    if (!this.operation.hasResolved()) {
                        this.operation.resolveModal(monitor);
                    }
                    if (this.operation.getProfileChangeRequest() != null) {
                        this.localJRECheckPlan = ProvUI.toCompabilityWithCurrentJREProvisioningPlan(this.operation, null);
                        if (!this.compatibleWithCurrentEE()) {
                            this.couldNotResolveStatus = this.localJRECheckPlan.getStatus();
                        }
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                return false;
            }
        }
        if (this.localJRECheckPlan == null) {
            return true;
        }
        IStatus currentEEPlanStatus = this.localJRECheckPlan.getStatus();
        if (currentEEPlanStatus.getSeverity() != 4) {
            return true;
        }
        return Stream.of(currentEEPlanStatus).filter(status -> status.getSeverity() == 4).flatMap(status -> status.isMultiStatus() ? Stream.of(status.getChildren()) : Stream.of(status)).filter(status -> status.getSeverity() == 4).flatMap(status -> status.isMultiStatus() ? Stream.of(status.getChildren()) : Stream.of(status)).filter(status -> status.getSeverity() == 4).flatMap(status -> status.isMultiStatus() ? Stream.of(status.getChildren()) : Stream.of(status)).map(IStatus::getMessage).noneMatch(message -> message.contains("osgi.ee"));
    }

    public void operationSelectionsChanged(ISelectableIUsPage page) {
        if (this.resolutionPage != null) {
            IWizardContainer container;
            boolean old = this.resolutionPage.isPageComplete();
            this.resolutionPage.setPageComplete(page.getCheckedIUElements() != null && page.getCheckedIUElements().length > 0);
            if (old != this.resolutionPage.isPageComplete() && (container = this.getContainer()) != null && container.getCurrentPage() != null) {
                this.getContainer().updateButtons();
            }
        }
    }

    private boolean shouldRecomputePlan(ISelectableIUsPage page) {
        boolean previouslyWaiting = this.waitingForOtherJobs;
        boolean previouslyCanceled = this.getCurrentStatus().getSeverity() == 8;
        this.waitingForOtherJobs = this.ui.hasScheduledOperations();
        return this.waitingForOtherJobs || previouslyWaiting || previouslyCanceled || this.pageSelectionsHaveChanged(page) || this.provisioningContextChanged();
    }

    protected boolean pageSelectionsHaveChanged(ISelectableIUsPage page) {
        HashSet<IInstallableUnit> selectedIUs = new HashSet<IInstallableUnit>();
        Object[] currentSelections = page.getCheckedIUElements();
        selectedIUs.addAll(ElementUtils.elementsToIUs(currentSelections));
        HashSet<IInstallableUnit> lastIUSelections = new HashSet<IInstallableUnit>();
        if (this.planSelections != null) {
            lastIUSelections.addAll(ElementUtils.elementsToIUs(this.planSelections));
        }
        return !selectedIUs.equals(lastIUSelections);
    }

    private boolean provisioningContextChanged() {
        ProvisioningContext currentProvisioningContext = this.getProvisioningContext();
        if (currentProvisioningContext == null && this.provisioningContext == null) {
            return false;
        }
        if (currentProvisioningContext != null && this.provisioningContext != null) {
            return !currentProvisioningContext.equals(this.provisioningContext);
        }
        return true;
    }

    protected void planChanged() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if ((currentPage == null || currentPage == this.mainPage) && this.remediationPage != null && this.remediationOperation != null && this.remediationOperation.getResolutionResult() == Status.OK_STATUS) {
            this.remediationPage.updateStatus(this.root, this.operation, this.planSelections);
        }
        this.resolutionPage.updateStatus(this.root, this.operation);
        if (this.errorPage != this.resolutionPage) {
            IUElementListRoot newRoot = this.shouldUpdateErrorPageModelOnPlanChange() ? this.root : null;
            this.errorPage.updateStatus(newRoot, this.operation);
        }
    }

    protected boolean shouldUpdateErrorPageModelOnPlanChange() {
        return this.errorPage != this.mainPage;
    }

    protected abstract void initializeResolutionModelElements(Object[] var1);

    protected ProvisioningContext getProvisioningContext() {
        if (this.operation != null) {
            return this.operation.getProvisioningContext();
        }
        return new ProvisioningContext(this.ui.getSession().getProvisioningAgent());
    }

    public void recomputePlan(IRunnableContext runnableContext) {
        this.recomputePlan(runnableContext, false);
    }

    public void computeRemediationOperation(ProfileChangeOperation op, ProvisioningUI pui, IProgressMonitor monitor) {
        monitor.setTaskName(ProvUIMessages.ProvisioningOperationWizard_Remediation_Operation);
        this.remediationOperation = new RemediationOperation(pui.getSession(), op.getProfileChangeRequest());
        this.remediationOperation.resolveModal(monitor);
        monitor.done();
    }

    public void recomputePlan(IRunnableContext runnableContext, boolean withRemediation) {
        this.couldNotResolveStatus = Status.OK_STATUS;
        this.provisioningContext = this.getProvisioningContext();
        this.operation = null;
        this.localJRECheckPlan = null;
        this.remediationOperation = null;
        this.initializeResolutionModelElements(this.getOperationSelections());
        if (this.planSelections.length == 0) {
            this.couldNotResolve(ProvUIMessages.ResolutionWizardPage_NoSelections);
        } else {
            this.operation = this.getProfileChangeOperation(this.planSelections);
            this.operation.setProvisioningContext(this.provisioningContext);
            try {
                runnableContext.run(true, true, monitor -> {
                    this.operation.resolveModal(monitor);
                    if (this.operation.getProfileChangeRequest() != null && this.getPolicy().getCheckAgainstCurrentExecutionEnvironment()) {
                        this.localJRECheckPlan = ProvUI.toCompabilityWithCurrentJREProvisioningPlan(this.operation, monitor);
                        if (!this.compatibleWithCurrentEE()) {
                            this.couldNotResolveStatus = this.localJRECheckPlan.getStatus();
                        }
                    }
                    if (withRemediation) {
                        IStatus status = this.operation.getResolutionResult();
                        if (this.remediationPage != null && this.shouldRemediate(status)) {
                            this.computeRemediationOperation(this.operation, this.ui, monitor);
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                ProvUI.handleException(e.getCause(), null, 3);
                this.couldNotResolve(null);
            }
        }
        this.planChanged();
    }

    public boolean shouldRemediate(IStatus status) {
        return status == null || status.getSeverity() == 4;
    }

    protected Object[] getOperationSelections() {
        return this.mainPage.getCheckedIUElements();
    }

    protected abstract ProfileChangeOperation getProfileChangeOperation(Object[] var1);

    void couldNotResolve(String message) {
        this.couldNotResolveStatus = message != null ? new Status(4, "org.eclipse.equinox.p2.ui", message, null) : new Status(4, "org.eclipse.equinox.p2.ui", ProvUIMessages.ProvisioningOperationWizard_UnexpectedFailureToResolve, null);
        StatusManager.getManager().handle(this.couldNotResolveStatus, 1);
    }

    public IStatus getCurrentStatus() {
        if (this.statusOverridesOperation()) {
            return this.couldNotResolveStatus;
        }
        if (this.operation != null && this.operation.getResolutionResult() != null) {
            if (!this.operation.getResolutionResult().isOK() || this.localJRECheckPlan == null || this.compatibleWithCurrentEE()) {
                return this.operation.getResolutionResult();
            }
            if (!this.compatibleWithCurrentEE()) {
                return this.localJRECheckPlan.getStatus();
            }
        }
        return this.couldNotResolveStatus;
    }

    public String getDialogSettingsSectionName() {
        return ((Object)((Object)this)).getClass().getName() + ".WizardSettings";
    }

    public void saveBoundsRelatedSettings() {
        IWizardPage[] pages;
        IWizardPage[] iWizardPageArray = pages = this.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof ProvisioningWizardPage) {
                ((ProvisioningWizardPage)page).saveBoundsRelatedSettings();
            }
            ++n2;
        }
    }

    protected Policy getPolicy() {
        return this.ui.getPolicy();
    }

    protected String getProfileId() {
        return this.ui.getProfileId();
    }

    protected boolean shouldShowProvisioningPlanChildren() {
        return ProvUI.getQueryContext(this.getPolicy()).getShowProvisioningPlanChildren();
    }

    public void createPageControls(Composite pageContainer) {
        this.ui.signalRepositoryOperationStart();
        super.createPageControls(pageContainer);
        if (this.repoPreloadJob != null) {
            if (this.repoPreloadJob.getProperty(LoadMetadataRepositoryJob.WIZARD_CLIENT_SHOULD_SCHEDULE) != null) {
                this.repoPreloadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent e) {
                        ProvisioningOperationWizard.this.asyncReportLoadFailures();
                    }
                });
                this.repoPreloadJob.schedule();
            } else if (this.repoPreloadJob.getState() == 0) {
                this.asyncReportLoadFailures();
            } else {
                this.repoPreloadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent e) {
                        ProvisioningOperationWizard.this.asyncReportLoadFailures();
                    }
                });
            }
        }
    }

    public void dispose() {
        this.ui.signalRepositoryOperationComplete(null, false);
        super.dispose();
    }

    void asyncReportLoadFailures() {
        if (this.repoPreloadJob != null && this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().getDisplay().asyncExec(() -> {
                if (PlatformUI.isWorkbenchRunning() && this.getShell() != null && !this.getShell().isDisposed()) {
                    this.repoPreloadJob.reportAccumulatedStatus();
                }
            });
        }
    }

    public boolean statusOverridesOperation() {
        return this.operation != null && this.operation.getResolutionResult() != null && this.operation.getResolutionResult().getSeverity() < 4 && this.localJRECheckPlan != null && !this.compatibleWithCurrentEE();
    }

    public void setRelaxedResolution(boolean value) {
        this.resolveWithRelaxedConstraints = value;
    }

    public boolean getRelaxedResoltion() {
        return this.resolveWithRelaxedConstraints;
    }
}

