/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLHelpProvider;
import org.jkiss.dbeaver.model.sql.SQLHelpTopic;
import org.jkiss.utils.CommonUtils;

public class MySQLHelpProvider
implements SQLHelpProvider {
    private static final Log log = Log.getLog(MySQLHelpProvider.class);
    private final MySQLDataSource dataSource;
    private final Map<String, SQLHelpTopic> topicCache = new HashMap<String, SQLHelpTopic>();
    private boolean isLoaded = false;

    public MySQLHelpProvider(MySQLDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public SQLHelpTopic findHelpTopic(DBRProgressMonitor monitor, String keyword, DBPKeywordType keywordType) {
        return this.selectHelpTopic(monitor, keyword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLHelpTopic selectHelpTopic(DBRProgressMonitor monitor, String topic) {
        if (CommonUtils.isEmpty((String)topic)) {
            return null;
        }
        if (!this.isLoaded) {
            this.loadTopics(monitor);
        }
        Map<String, SQLHelpTopic> map = this.topicCache;
        synchronized (map) {
            return this.topicCache.get(topic.toUpperCase(Locale.ENGLISH));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTopics(DBRProgressMonitor monitor) {
        block37: {
            try {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (String)"Read MySQL help topics");){
                        Throwable throwable2 = null;
                        Object var6_10 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT name, description, example, url FROM mysql.help_topic");){
                            Throwable throwable3 = null;
                            Object var9_15 = null;
                            try {
                                JDBCResultSet dbResult = dbStat.executeQuery();
                                block23: while (true) {
                                    while (dbResult.next()) {
                                        String topicName = dbResult.getString(1);
                                        SQLHelpTopic helpTopic = new SQLHelpTopic();
                                        helpTopic.setContents("<pre>" + dbResult.getString(2) + "</pre>");
                                        helpTopic.setExample(dbResult.getString(3));
                                        helpTopic.setUrl(dbResult.getString(4));
                                        if (topicName == null) continue;
                                        Map<String, SQLHelpTopic> map = this.topicCache;
                                        synchronized (map) {
                                            this.topicCache.put(topicName.toUpperCase(Locale.ENGLISH), helpTopic);
                                            continue block23;
                                        }
                                    }
                                    break block37;
                                    {
                                        continue block23;
                                        break;
                                    }
                                    break;
                                }
                                finally {
                                    if (dbResult != null) {
                                        dbResult.close();
                                    }
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error reading MySQL help topics", (Throwable)e);
                    this.isLoaded = true;
                }
            }
            finally {
                this.isLoaded = true;
            }
        }
    }
}

