/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.kingbase.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.kingbase.KingbaseUtils;
import org.jkiss.dbeaver.ext.kingbase.model.KingbaseDatabase;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.PostgreValueParser;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDependency;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureKind;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureParameter;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class KingbaseProcedure
extends PostgreProcedure {
    private static final Log log = Log.getLog(KingbaseProcedure.class);
    public long propackageid;
    public String prokind;
    public String procSrc;
    public PostgreProcedureKind kind;
    public String body = this.getBody();

    public long getPropackageid() {
        return this.propackageid;
    }

    public KingbaseProcedure(PostgreSchema schema) {
        super(schema);
    }

    public KingbaseProcedure(DBRProgressMonitor monitor, PostgreSchema schema, ResultSet dbResult) {
        super(schema);
        this.persisted = true;
        this.propackageid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"propackageid");
        this.procSrc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"prosrc");
        this.loadInfo(monitor, dbResult);
    }

    private void loadInfo(DBRProgressMonitor monitor, ResultSet dbResult) {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"poid");
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"proname"));
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"proowner");
        this.languageId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"prolang");
        this.execCost = JDBCUtils.safeGetFloat((ResultSet)dbResult, (String)"procost");
        this.estRows = JDBCUtils.safeGetFloat((ResultSet)dbResult, (String)"prorows");
        Number[] allArgTypes = PostgreUtils.safeGetNumberArray((ResultSet)dbResult, (String)"proallargtypes");
        String[] argNames = PostgreUtils.safeGetStringArray((ResultSet)dbResult, (String)"proargnames");
        this.argTypesJudge(allArgTypes, dbResult, monitor, argNames);
        try {
            String argDefaultsString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"arg_defaults");
            String[] argDefaults = null;
            argDefaults = this.argDefaultsJudge(argDefaultsString, argDefaults);
            this.paramsSetDefaultValue(argDefaults);
        }
        catch (Exception e) {
            log.error((Object)"Error parsing parameters defaults", (Throwable)e);
        }
        this.overloadedName = KingbaseProcedure.makeOverloadedName(this.getSchema(), this.getName(), this.params, false, false, false);
        long varTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"provariadic");
        this.varArrayType(varTypeId, monitor);
        this.procTransform = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"protransform");
        this.isAggregate = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proisagg");
        this.isWindow = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proiswindow");
        this.isSecurityDefiner = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"prosecdef");
        this.leakproof = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proleakproof");
        this.isStrict = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proisstrict");
        this.returnsSet = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proretset");
        try {
            String provolatile = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"provolatile");
            this.procVolatile = provolatile == null ? null : PostgreProcedure.ProcedureVolatile.valueOf((String)provolatile);
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)e);
        }
        long retTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"prorettype");
        this.returnTypeJudge(retTypeId, monitor);
        this.procSrc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"prosrc");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.acl = JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"proacl");
        this.config = PostgreUtils.safeGetStringArray((ResultSet)dbResult, (String)"proconfig");
        PostgreDataSource dataSource = (PostgreDataSource)this.getDataSource();
        this.procedureJudge(dataSource, dbResult);
    }

    private void argTypesJudge(Number[] allArgTypes, ResultSet dbResult, DBRProgressMonitor monitor, String[] argNames) {
        if (!ArrayUtils.isEmpty((Object[])allArgTypes)) {
            String[] argModes = PostgreUtils.safeGetStringArray((ResultSet)dbResult, (String)"proargmodes");
            this.allArgTypesJudge(allArgTypes, monitor, argNames, argModes);
        } else {
            long[] inArgTypes = KingbaseUtils.getIdVector(JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"proargtypes"));
            this.inArgTypesJudge(inArgTypes, monitor, argNames);
        }
    }

    private void allArgTypesJudge(Number[] allArgTypes, DBRProgressMonitor monitor, String[] argNames, String[] argModes) {
        int i = 0;
        while (i < allArgTypes.length) {
            long paramType = allArgTypes[i].longValue();
            PostgreDataType dataType = ((PostgreSchema)this.container).getDatabase().getDataType(monitor, paramType);
            if (dataType == null) {
                log.warn((Object)("Parameter data type [" + paramType + "] not found"));
            } else {
                String paramName = argNames == null || argNames.length < allArgTypes.length ? "$" + (i + 1) : argNames[i];
                PostgreProcedure.ArgumentMode mode = PostgreProcedure.ArgumentMode.i;
                if (argModes != null && argModes.length == allArgTypes.length) {
                    try {
                        mode = PostgreProcedure.ArgumentMode.valueOf((String)argModes[i]);
                    }
                    catch (IllegalArgumentException e) {
                        log.debug((Object)e);
                    }
                }
                this.params.add(new PostgreProcedureParameter((PostgreProcedure)this, paramName, dataType, mode, i + 1));
            }
            ++i;
        }
    }

    private String[] argDefaultsJudge(String argDefaultsString, String[] argDefaults) {
        String[] newArgDefaults = argDefaults;
        if (!CommonUtils.isEmpty((String)argDefaultsString)) {
            try {
                newArgDefaults = PostgreValueParser.parseSingleObject((String)argDefaultsString);
            }
            catch (DBCException e) {
                log.debug((Object)"Error parsing function parameters defaults", (Throwable)e);
            }
        }
        return newArgDefaults;
    }

    private void paramsSetDefaultValue(String[] argDefaults) {
        if (argDefaults != null && argDefaults.length > 0) {
            int paramsAssigned = 0;
            int i = this.params.size() - 1;
            while (i >= 0) {
                DBSProcedureParameterKind parameterKind = ((PostgreProcedureParameter)this.params.get(i)).getParameterKind();
                if (parameterKind != DBSProcedureParameterKind.OUT && parameterKind != DBSProcedureParameterKind.TABLE && parameterKind != DBSProcedureParameterKind.RETURN) {
                    String defaultValue = argDefaults[argDefaults.length - 1 - paramsAssigned];
                    if (defaultValue != null) {
                        defaultValue = defaultValue.trim();
                    }
                    ((PostgreProcedureParameter)this.params.get(i)).setDefaultValue(defaultValue);
                    if (++paramsAssigned >= argDefaults.length) break;
                }
                --i;
            }
        }
    }

    private void inArgTypesJudge(long[] inArgTypes, DBRProgressMonitor monitor, String[] argNames) {
        if (!ArrayUtils.isEmpty((long[])inArgTypes)) {
            int i = 0;
            while (i < inArgTypes.length) {
                Long paramType = inArgTypes[i];
                PostgreDataType dataType = ((PostgreSchema)this.container).getDatabase().getDataType(monitor, (long)paramType.intValue());
                if (dataType == null) {
                    log.warn((Object)("Parameter data type [" + String.valueOf(paramType) + "] not found"));
                } else {
                    String paramName = argNames == null || argNames.length < inArgTypes.length ? "$" + (i + 1) : argNames[i];
                    PostgreProcedureParameter param = new PostgreProcedureParameter((PostgreProcedure)this, paramName, dataType, PostgreProcedure.ArgumentMode.i, i + 1);
                    this.params.add(param);
                }
                ++i;
            }
        }
    }

    private void procedureJudge(PostgreDataSource dataSource, ResultSet dbResult) {
        if (dataSource.getServerType().supportsStoredProcedures()) {
            String proKind = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"prokind");
            this.kind = (PostgreProcedureKind)CommonUtils.valueOf(PostgreProcedureKind.class, (String)proKind, (Enum)PostgreProcedureKind.f);
            this.kindAJudge();
        } else {
            this.kindJudge(dbResult);
        }
    }

    private void varArrayType(long varTypeId, DBRProgressMonitor monitor) {
        if (varTypeId != 0L) {
            this.varArrayType = ((PostgreSchema)this.container).getDatabase().getDataType(monitor, varTypeId);
        }
    }

    private void returnTypeJudge(long retTypeId, DBRProgressMonitor monitor) {
        if (retTypeId != 0L) {
            this.returnType = ((PostgreSchema)this.container).getDatabase().getDataType(monitor, retTypeId);
        }
    }

    private void kindAJudge() {
        if (this.kind == PostgreProcedureKind.a) {
            this.isAggregate = true;
        }
    }

    private void kindJudge(ResultSet dbResult) {
        if (this.isAggregate) {
            this.kind = PostgreProcedureKind.a;
        } else if (this.isWindow) {
            this.kind = PostgreProcedureKind.w;
        } else {
            boolean isProcedure = false;
            try {
                isProcedure = dbResult.getBoolean("prosp");
            }
            catch (SQLException e) {
                log.debug((Object)"Error get procedure.", (Throwable)e);
            }
            this.kind = isProcedure ? PostgreProcedureKind.p : PostgreProcedureKind.f;
        }
    }

    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreSchema)this.container).getDatabase();
    }

    @Property(viewable=false, order=3)
    public PostgreProcedureKind getKind() {
        return this.kind;
    }

    public void setKind(PostgreProcedureKind kind) {
        this.kind = kind;
    }

    @Property(order=5)
    public long getObjectId() {
        return this.oid;
    }

    public DBSProcedureType getProcedureType() {
        switch (this.kind) {
            case f: 
            case a: 
            case w: {
                return DBSProcedureType.FUNCTION;
            }
        }
        return DBSProcedureType.PROCEDURE;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getBody() {
        return this.body;
    }

    @Nullable
    public List<PostgreProcedureParameter> getParameters(@NotNull DBRProgressMonitor monitor) {
        return this.params;
    }

    public List<PostgreProcedureParameter> getInputParameters() {
        ArrayList<PostgreProcedureParameter> result = new ArrayList<PostgreProcedureParameter>();
        for (PostgreProcedureParameter param : this.params) {
            if (!param.getParameterKind().isInput()) continue;
            result.add(param);
        }
        return result;
    }

    public List<PostgreProcedureParameter> getParameters(DBSProcedureParameterKind kind) {
        ArrayList<PostgreProcedureParameter> result = new ArrayList<PostgreProcedureParameter>();
        for (PostgreProcedureParameter param : this.params) {
            if (param.getParameterKind() != kind) continue;
            result.add(param);
        }
        return result;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @NotNull
    public String getOverloadedName() {
        return this.overloadedName;
    }

    @NotNull
    public String getUniqueName() {
        return this.overloadedName;
    }

    public String getSpecificName() {
        return this.name + "_" + this.getObjectId();
    }

    public void setName(String name) {
        super.setName(name);
        this.overloadedName = KingbaseProcedure.makeOverloadedName(this.getSchema(), this.getName(), this.params, false, false, false);
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        Object procDDL;
        boolean omitHeader = CommonUtils.getOption(options, (String)"debugger.source");
        Object object = procDDL = omitHeader || CommonUtils.getOption(options, (String)"ddl.skipDrops") ? "" : "-- DROP " + this.getProcedureTypeName() + " " + this.getFullQualifiedSignature() + ";\n\n";
        if (this.isPersisted() && (!((PostgreDataSource)this.getDataSource()).getServerType().supportsFunctionDefRead() || omitHeader) && !this.isAggregate) {
            this.procSrcJudge(monitor);
            PostgreDataType returnType = this.getReturnType();
            String returnTypeName = returnType == null ? null : returnType.getFullTypeName();
            procDDL = (String)procDDL + (omitHeader ? this.procSrc : this.generateFunctionDeclaration(this.getLanguage(monitor), returnTypeName, this.procSrc));
        } else {
            this.bodyJudge(monitor);
            procDDL = (String)procDDL + this.body;
        }
        procDDL = this.omitHeaderJudge(omitHeader, (String)procDDL, options, monitor);
        return procDDL;
    }

    private String bodyJudge(DBRProgressMonitor monitor) throws DBException {
        if (this.body == null) {
            if (!this.isPersisted()) {
                PostgreDataType returnType = this.getReturnType();
                String returnTypeName = returnType == null ? null : returnType.getFullTypeName();
                this.body = this.generateFunctionDeclaration(this.getLanguage(monitor), returnTypeName, "\n\t-- Enter function body here\n");
            } else if (this.oid == 0L) {
                this.body = this.procSrc;
            } else if (this.isAggregate) {
                this.configureAggregateQuery(monitor);
            } else {
                try {
                    Throwable returnType = null;
                    Object var3_7 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read procedure body");){
                        this.body = JDBCUtils.queryString((Connection)session, (String)("SELECT sys_get_functiondef(" + this.getObjectId() + ")"), (Object[])new Object[0]);
                    }
                    catch (Throwable throwable) {
                        if (returnType == null) {
                            returnType = throwable;
                        } else if (returnType != throwable) {
                            returnType.addSuppressed(throwable);
                        }
                        throw returnType;
                    }
                }
                catch (SQLException e) {
                    throw new DBException("Error reading procedure body", (Throwable)e);
                }
            }
        }
        return this.body;
    }

    private String procSrcJudge(DBRProgressMonitor monitor) throws DBException {
        if (this.procSrc == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read procedure body");){
                    this.procSrc = JDBCUtils.queryString((Connection)session, (String)"SELECT prosrc FROM sys_proc where oid = ?", (Object[])new Object[]{this.getObjectId()});
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException("Error reading procedure body", (Throwable)e);
            }
        }
        return this.procSrc;
    }

    private String omitHeaderJudge(boolean omitHeader, String procDDL, Map<String, Object> options, DBRProgressMonitor monitor) throws DBException {
        Object newProcDDL = procDDL;
        if (this.isPersisted() && !omitHeader) {
            newProcDDL = (String)newProcDDL + ";\n";
            if (CommonUtils.getOption(options, (String)"ddl.includeComments") && !CommonUtils.isEmpty((String)this.getDescription())) {
                newProcDDL = (String)newProcDDL + "\nCOMMENT ON " + this.getProcedureTypeName() + " " + this.getFullQualifiedSignature() + " IS " + SQLUtils.quoteString((DBSObject)this, (String)this.getDescription()) + ";\n";
            }
            if (CommonUtils.getOption(options, (String)"ddl.includePermissions")) {
                ArrayList actions = new ArrayList();
                PostgreUtils.getObjectGrantPermissionActions((DBRProgressMonitor)monitor, (PostgrePrivilegeOwner)this, actions, options);
                newProcDDL = (String)newProcDDL + "\n" + SQLUtils.generateScript((DBPDataSource)this.getDataSource(), (DBEPersistAction[])actions.toArray(new DBEPersistAction[0]), (boolean)false);
            }
        }
        return newProcDDL;
    }

    private void configureAggregateQuery(DBRProgressMonitor monitor) throws DBCException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read aggregate function body");){
                String query = "SELECT (sys_identify_object('sys_proc'::regclass, aggfnoid, 0)).identity,\naggtransfn::regproc,\nformat_type(aggtranstype, NULL) as aggtranstype,\nCASE aggfinalfn WHEN '-'::regproc THEN NULL ELSE aggfinalfn::text END,\nCASE aggsortop WHEN 0 THEN NULL ELSE oprname END,\nagginitval, aggmtransfn, aggminvtransfn,\naggfinalextra, aggmfinalextra, aggserialfn, aggdeserialfn, aggmfinalfn,\nformat_type(aggmtranstype, NULL) as aggmtranstype\n,aggfinalmodify, aggmfinalmodify FROM sys_aggregate\nLEFT JOIN sys_operator ON sys_operator.oid = aggsortop\nWHERE aggfnoid = ?::regproc";
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(query);){
                    dbStat.setString(1, this.getFullyQualifiedName(DBPEvaluationContext.DDL));
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            String fullName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"identity");
                            String aggtransfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggtransfn");
                            String aggtranstype = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggtranstype");
                            TransitionModifies finalmodify = null;
                            TransitionModifies mfinalmodify = null;
                            finalmodify = TransitionModifies.valueOf(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggfinalmodify"));
                            mfinalmodify = TransitionModifies.valueOf(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggmfinalmodify"));
                            boolean finalextra = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"aggfinalextra");
                            StringBuilder aggregateBody = new StringBuilder("CREATE OR REPLACE AGGREGATE ");
                            aggregateBody.append(fullName).append(" (\n").append("\tSFUNC = ").append(aggtransfn).append(",\n\t").append("STYPE = ").append(aggtranstype);
                            String aggfinalfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggfinalfn");
                            this.aggfinalfnJudge(aggfinalfn, aggregateBody, finalextra, ",\n\t", finalmodify);
                            String serialfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggserialfn");
                            this.serialfnJudge(serialfn, aggregateBody, "-", ",\n\t");
                            String deserialfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggdeserialfn");
                            this.deserialfnJudge(deserialfn, aggregateBody, "-", ",\n\t");
                            String initval = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"agginitval");
                            this.initvalJudge(initval, aggregateBody, ",\n\t");
                            String mtransfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggmtransfn");
                            String mtranstype = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggmtranstype");
                            this.mtransfnJudge(mtransfn, mtranstype, "-", aggregateBody, ",\n\t");
                            String minvtransfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggminvtransfn");
                            this.minvtransfnJudge(minvtransfn, "-", aggregateBody, ",\n\t");
                            String mfinalfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggmfinalfn");
                            boolean mfinalextra = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"aggmfinalextra");
                            this.mfinalfnJudge(mfinalfn, "-", mfinalextra, mfinalmodify, aggregateBody, ",\n\t");
                            String oprname = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"oprname");
                            this.oprNameJudge(oprname, aggregateBody, ",\n\t");
                            aggregateBody.append("\n)");
                            this.body = aggregateBody.toString();
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Error reading aggregate function body", (Throwable)e);
            this.body = "-- Aggregate function " + this.getFullQualifiedSignature() + "\n-- " + e.getMessage();
        }
    }

    private StringBuilder mfinalfnJudge(String mfinalfn, String notResult, boolean mfinalextra, TransitionModifies mfinalmodify, StringBuilder aggregateBody, String delim) {
        if (CommonUtils.isNotEmpty((String)mfinalfn) && !notResult.equals(mfinalfn)) {
            aggregateBody.append(delim).append("MFINALFUNC = ").append(mfinalfn);
            this.mfinalextraJudge(mfinalextra, aggregateBody, delim);
            this.mfinalmodifyJudge(mfinalmodify, aggregateBody, delim);
        }
        return aggregateBody;
    }

    private StringBuilder mfinalextraJudge(boolean mfinalextra, StringBuilder aggregateBody, String delim) {
        if (mfinalextra) {
            aggregateBody.append(delim).append("MFINALFUNC_EXTRA");
        }
        return aggregateBody;
    }

    private StringBuilder mfinalmodifyJudge(TransitionModifies mfinalmodify, StringBuilder aggregateBody, String delim) {
        if (mfinalmodify != null) {
            aggregateBody.append(delim).append("MFINALFUNC_MODIFY = ").append(mfinalmodify.keyword);
        }
        return aggregateBody;
    }

    private StringBuilder oprNameJudge(String oprname, StringBuilder aggregateBody, String delim) {
        if (CommonUtils.isNotEmpty((String)oprname)) {
            aggregateBody.append(delim).append("SORTOP = ").append(oprname);
        }
        return aggregateBody;
    }

    private StringBuilder minvtransfnJudge(String minvtransfn, String notResult, StringBuilder aggregateBody, String delim) {
        if (CommonUtils.isNotEmpty((String)minvtransfn) && !notResult.equals(minvtransfn)) {
            aggregateBody.append(delim).append("MINVFUNC = ").append(minvtransfn);
        }
        return aggregateBody;
    }

    private StringBuilder mtransfnJudge(String mtransfn, String mtranstype, String notResult, StringBuilder aggregateBody, String delim) {
        if (CommonUtils.isNotEmpty((String)mtransfn) && !notResult.equals(mtransfn)) {
            aggregateBody.append(delim).append("MSFUNC = ").append(mtransfn);
            this.mtranstypeJudge(mtranstype, notResult, aggregateBody, delim);
        }
        return aggregateBody;
    }

    private StringBuilder mtranstypeJudge(String mtranstype, String notResult, StringBuilder aggregateBody, String delim) {
        if (CommonUtils.isNotEmpty((String)mtranstype) && !notResult.equals(mtranstype)) {
            aggregateBody.append(delim).append("MSTYPE = ").append(mtranstype);
        }
        return aggregateBody;
    }

    private StringBuilder initvalJudge(String initval, StringBuilder aggregateBody, String delim) {
        Object newInitval = initval;
        if (CommonUtils.isNotEmpty((String)initval)) {
            if (!Pattern.matches("[0-9]+", initval)) {
                newInitval = "'" + initval + "'";
            }
            aggregateBody.append(delim).append("INITCOND = ").append((String)newInitval);
        }
        return aggregateBody;
    }

    private StringBuilder aggfinalfnJudge(String aggfinalfn, StringBuilder aggregateBody, boolean finalextra, String delim, TransitionModifies finalmodify) {
        if (CommonUtils.isNotEmpty((String)aggfinalfn)) {
            aggregateBody.append(delim).append("FINALFUNC = ").append(aggfinalfn);
            this.finalextraJudge(aggregateBody, finalextra, delim);
            this.finalmodifyJudge(aggregateBody, finalmodify, delim);
        }
        return aggregateBody;
    }

    private StringBuilder finalextraJudge(StringBuilder aggregateBody, boolean finalextra, String delim) {
        if (finalextra) {
            aggregateBody.append(delim).append("FINALFUNC_EXTRA");
        }
        return aggregateBody;
    }

    private StringBuilder finalmodifyJudge(StringBuilder aggregateBody, TransitionModifies finalmodify, String delim) {
        if (finalmodify != null) {
            aggregateBody.append(delim).append("FINALFUNC_MODIFY = ").append(finalmodify.keyword);
        }
        return aggregateBody;
    }

    private StringBuilder serialfnJudge(String serialfn, StringBuilder aggregateBody, String notResult, String delim) {
        if (CommonUtils.isNotEmpty((String)serialfn) && !notResult.equals(serialfn)) {
            aggregateBody.append(delim).append("SERIALFUNC = ").append(serialfn);
        }
        return aggregateBody;
    }

    private StringBuilder deserialfnJudge(String deserialfn, StringBuilder aggregateBody, String notResult, String delim) {
        if (CommonUtils.isNotEmpty((String)deserialfn) && !notResult.equals(deserialfn)) {
            aggregateBody.append(delim).append("DESERIALFUNC = ").append(deserialfn);
        }
        return aggregateBody;
    }

    protected String generateFunctionDeclaration(PostgreLanguage language, String returnTypeName, String functionBody) {
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        StringBuilder decl = new StringBuilder();
        String functionSignature = KingbaseProcedure.makeOverloadedName(this.getSchema(), this.getName(), this.params, true, true, true);
        decl.append("CREATE OR REPLACE ").append(this.getProcedureTypeName()).append(" ").append(DBUtils.getQuotedIdentifier((DBSObject)this.getContainer())).append(".").append(functionSignature).append(lineSeparator);
        this.returnJudge(returnTypeName, decl, lineSeparator);
        this.languageJudge(language, decl, lineSeparator);
        this.securityJudge(decl, lineSeparator);
        this.windowJudge(decl, lineSeparator);
        this.procedureTypeJudge(decl, lineSeparator);
        this.strictJudge(decl, lineSeparator);
        this.execCostJudge(decl, lineSeparator);
        this.estRowsJudge(decl, lineSeparator);
        if (!ArrayUtils.isEmpty((Object[])this.config)) {
            this.configJudge(decl, lineSeparator);
        }
        String delimiter = "$$";
        decl.append("AS ").append(delimiter).append("\n");
        this.functionBodyJudge(functionBody, decl);
        decl.append(delimiter).append(lineSeparator);
        return decl.toString();
    }

    private StringBuilder returnJudge(String returnTypeName, StringBuilder decl, String lineSeparator) {
        if (this.getProcedureType().hasReturnValue() && !CommonUtils.isEmpty((String)returnTypeName)) {
            decl.append("\tRETURNS ");
            if (this.isReturnsSet()) {
                List<PostgreProcedureParameter> tableParams = this.getParameters(DBSProcedureParameterKind.TABLE);
                this.tableParamsJudge(tableParams, decl, returnTypeName);
            } else {
                decl.append(returnTypeName);
            }
            decl.append(lineSeparator);
        }
        return decl;
    }

    private StringBuilder tableParamsJudge(List<PostgreProcedureParameter> tableParams, StringBuilder decl, String returnTypeName) {
        if (!tableParams.isEmpty()) {
            decl.append("TABLE (");
            this.tableParamsSizeJudge(tableParams, decl);
            decl.append(")");
        } else {
            decl.append("SETOF ").append(returnTypeName);
        }
        return decl;
    }

    private StringBuilder tableParamsSizeJudge(List<PostgreProcedureParameter> tableParams, StringBuilder decl) {
        int i = 0;
        while (i < tableParams.size()) {
            PostgreProcedureParameter tp = tableParams.get(i);
            if (i > 0) {
                decl.append(", ");
            }
            decl.append(tp.getName()).append(" ").append(tp.getTypeName());
            ++i;
        }
        return decl;
    }

    private StringBuilder configJudge(StringBuilder decl, String lineSeparator) {
        String[] stringArray = this.config;
        int n = this.config.length;
        int n2 = 0;
        while (n2 < n) {
            String configLine = stringArray[n2];
            int divPos = configLine.indexOf(61);
            if (divPos != -1) {
                String paramName = configLine.substring(0, divPos);
                String paramValue = configLine.substring(divPos + 1);
                boolean isNumeric = true;
                try {
                    Double.parseDouble(paramValue);
                }
                catch (NumberFormatException numberFormatException) {
                    isNumeric = false;
                }
                decl.append("\tSET ").append(paramName).append(" = ").append((String)(isNumeric ? paramValue : "'" + paramValue + "'")).append(lineSeparator);
            } else {
                log.debug((Object)("Wrong function configuration parameter [" + configLine + "]"));
            }
            ++n2;
        }
        return decl;
    }

    private StringBuilder languageJudge(PostgreLanguage language, StringBuilder decl, String lineSeparator) {
        if (language != null) {
            decl.append("\tLANGUAGE ").append(language).append(lineSeparator);
        }
        return decl;
    }

    private StringBuilder securityJudge(StringBuilder decl, String lineSeparator) {
        if (this.isSecurityDefiner()) {
            decl.append("\tSECURITY DEFINER").append(lineSeparator);
        }
        return decl;
    }

    private StringBuilder windowJudge(StringBuilder decl, String lineSeparator) {
        if (this.isWindow()) {
            decl.append("\tWINDOW").append(lineSeparator);
        }
        return decl;
    }

    private StringBuilder strictJudge(StringBuilder decl, String lineSeparator) {
        if (this.isStrict) {
            decl.append("\tSTRICT").append(lineSeparator);
        }
        return decl;
    }

    private StringBuilder procedureTypeJudge(StringBuilder decl, String lineSeparator) {
        if (this.getProcedureType() == DBSProcedureType.FUNCTION && this.procVolatile != null) {
            decl.append("\t").append(this.procVolatile.getCreateClause()).append(lineSeparator);
        }
        return decl;
    }

    private StringBuilder execCostJudge(StringBuilder decl, String lineSeparator) {
        if (this.execCost > 0.0f && this.execCost != 100.0f) {
            decl.append("\tCOST ").append(CommonUtils.niceFormatFloat((float)this.execCost)).append(lineSeparator);
        }
        return decl;
    }

    private StringBuilder estRowsJudge(StringBuilder decl, String lineSeparator) {
        if (this.estRows > 0.0f && this.estRows != 1000.0f) {
            decl.append("\tROWS ").append(CommonUtils.niceFormatFloat((float)this.estRows)).append(lineSeparator);
        }
        return decl;
    }

    private StringBuilder functionBodyJudge(String functionBody, StringBuilder decl) {
        if (!CommonUtils.isEmpty((String)functionBody)) {
            decl.append("\t").append(functionBody).append("\n");
        }
        return decl;
    }

    public void setObjectDefinitionText(String sourceText) {
        this.body = sourceText;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    @Property(category="Properties", order=10)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        if (!((PostgreDataSource)this.getDataSource()).getServerType().supportsRoles()) {
            return null;
        }
        return ((PostgreSchema)this.container).getDatabase().getRoleById(monitor, this.ownerId);
    }

    @Property(category="Properties", viewable=true, order=11)
    public PostgreLanguage getLanguage(DBRProgressMonitor monitor) throws DBException {
        return (PostgreLanguage)PostgreUtils.getObjectById((DBRProgressMonitor)monitor, (AbstractObjectCache)new KingbaseDatabase.LanguageCache(), (DBSObject)((PostgreSchema)this.container).getDatabase(), (long)this.languageId);
    }

    public void setLanguage(PostgreLanguage language) {
        this.languageId = language.getObjectId();
    }

    @Property(category="Properties", viewable=true, order=12)
    public PostgreDataType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(PostgreDataType returnType) {
        this.returnType = returnType;
    }

    @Property(category="Properties", viewable=false, order=13)
    public PostgreDataType getVarArrayType() {
        return this.varArrayType;
    }

    @Property(category="Properties", viewable=false, order=14)
    public String getProcTransform() {
        return this.procTransform;
    }

    @Property(category="Statistics", viewable=false, order=30)
    public float getExecCost() {
        return this.execCost;
    }

    @Property(category="Statistics", viewable=false, order=31)
    public float getEstRows() {
        return this.estRows;
    }

    @Property(category="Flags", viewable=true, order=100)
    public boolean isAggregate() {
        return this.isAggregate;
    }

    @Property(category="Flags", viewable=true, order=101)
    public boolean isWindow() {
        return this.isWindow;
    }

    @Property(category="Flags", viewable=true, order=102)
    public boolean isSecurityDefiner() {
        return this.isSecurityDefiner;
    }

    @Property(category="Flags", viewable=true, order=103)
    public boolean isLeakproof() {
        return this.leakproof;
    }

    @Property(category="Flags", viewable=true, order=104)
    public boolean isStrict() {
        return this.isStrict;
    }

    @Property(category="Flags", viewable=true, order=105)
    public boolean isReturnsSet() {
        return this.returnsSet;
    }

    @Property(category="Flags", viewable=true, order=106)
    public PostgreProcedure.ProcedureVolatile getProcVolatile() {
        return this.procVolatile;
    }

    public static String makeOverloadedName(@NotNull PostgreSchema schema, @NotNull String name, @NotNull List<PostgreProcedureParameter> params, boolean quote, boolean showParamNames, boolean forDDL) {
        String selfName = quote ? DBUtils.getQuotedIdentifier((DBPDataSource)schema.getDataSource(), (String)name) : name;
        StringJoiner signature = new StringJoiner(", ", "(", ")");
        List keywordParams = params.stream().filter(x -> x.getArgumentMode().getKeyword() != null).collect(Collectors.toList());
        boolean allIn = keywordParams.stream().allMatch(x -> x.getArgumentMode() == PostgreProcedure.ArgumentMode.i);
        for (PostgreProcedureParameter param : keywordParams) {
            PostgreDataType dataType;
            PostgreSchema typeContainer;
            StringJoiner parameter = new StringJoiner(" ");
            if (!allIn) {
                parameter.add(param.getArgumentMode().getKeyword());
            }
            if (showParamNames) {
                String paramName = param.getName();
                if (!forDDL || !paramName.startsWith("$")) {
                    parameter.add(paramName);
                }
            }
            if ((typeContainer = (PostgreSchema)(dataType = param.getParameterType()).getParentObject()).isPublicSchema() || typeContainer.isCatalogSchema()) {
                parameter.add(dataType.getName());
            } else {
                parameter.add(dataType.getFullyQualifiedName(DBPEvaluationContext.DDL));
            }
            String paramDefaultValue = param.getDefaultValue();
            if (forDDL && CommonUtils.isNotEmpty((String)paramDefaultValue)) {
                parameter.add("DEFAULT").add(paramDefaultValue);
            }
            signature.add(parameter.toString());
        }
        return selfName + String.valueOf(signature);
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=200)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    public String getFullQualifiedSignature() {
        return DBUtils.getQuotedIdentifier((DBSObject)this.getContainer()) + "." + KingbaseProcedure.makeOverloadedName(this.getSchema(), this.getName(), this.params, true, false, false);
    }

    public String getProcedureTypeName() {
        return this.kind.getName().toUpperCase(Locale.ENGLISH);
    }

    public PostgreSchema getSchema() {
        return (PostgreSchema)this.container;
    }

    public Collection<PostgrePrivilege> getPrivileges(@NotNull DBRProgressMonitor monitor, boolean includeNestedObjects) throws DBException {
        return PostgreUtils.extractPermissionsFromACL((DBRProgressMonitor)monitor, (PostgrePrivilegeOwner)this, (Object)this.acl, (boolean)false);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((PostgreSchema)this.getContainer()).getProceduresCache().refreshObject(monitor, (DBSObject)((PostgreSchema)this.getContainer()), (DBSObject)this);
    }

    public String generateChangeOwnerQuery(@NotNull String owner, @NotNull Map<String, Object> options) {
        return "ALTER " + this.getProcedureTypeName() + " " + this.getFullQualifiedSignature() + " OWNER TO " + owner;
    }

    @Association
    public List<PostgreDependency> getDependencies(DBRProgressMonitor monitor) throws DBCException {
        return PostgreDependency.readDependencies((DBRProgressMonitor)monitor, (PostgreObject)this, (boolean)true);
    }

    public boolean supportsObjectDefinitionOption(String option) {
        return "ddl.includeComments".equals(option) || "ddl.includePermissions".equals(option) || "sql.castParameter".equals(option);
    }

    public String toString() {
        return this.overloadedName == null ? this.name : this.overloadedName;
    }

    static enum TransitionModifies {
        r("READ_ONLY"),
        s("SHAREABLE"),
        w("READ_WRITE");

        private final String keyword;

        private TransitionModifies(String keyword) {
            this.keyword = keyword;
        }
    }
}

