/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CubridView
extends GenericView {
    private CubridUser owner;

    public CubridView(@NotNull GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName != null ? tableName.toLowerCase() : null, tableType, dbResult);
        String type;
        if (dbResult != null && (type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"is_system_class")) != null) {
            this.setSystem(type.equals("YES"));
        }
        this.owner = (CubridUser)container;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    public void setName(String name) {
        super.setName(name != null ? name.toLowerCase() : null);
    }

    public void setSchema(@NotNull CubridUser owner) {
        this.owner = owner;
    }

    @Property(viewable=true, order=2)
    public String getTableType() {
        return super.getTableType();
    }

    @NotNull
    public CubridDataSource getDataSource() {
        return (CubridDataSource)super.getDataSource();
    }

    @NotNull
    public String getUniqueName() {
        if (this.getDataSource().getSupportMultiSchema()) {
            return String.valueOf(this.getContainer()) + "." + this.getName();
        }
        return this.getName();
    }

    public boolean isEnableSchema() {
        return this.getDataSource().getSupportMultiSchema() || this.getDataSource().isDBAGroup();
    }

    @Property(viewable=true, editableExpr="object.enableSchema", updatableExpr="object.enableSchema", listProvider=OwnerListProvider.class, labelProvider=GenericSchema.SchemaNameTermProvider.class, order=2)
    @NotNull
    public GenericSchema getSchema() {
        return this.owner;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    public String getDescription() {
        return super.getDescription();
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        if (this.isSystem() || !this.getDataSource().getSupportMultiSchema()) {
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this});
        }
        return DBUtils.getQuotedIdentifier((DBSObject)this.getSchema()) + "." + DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this});
    }

    public static class OwnerListProvider
    implements IPropertyValueListProvider<CubridView> {
        @NotNull
        public boolean allowCustomValue() {
            return false;
        }

        @NotNull
        public Object[] getPossibleValues(@NotNull CubridView object) {
            return object.getDataSource().getSchemas().toArray();
        }
    }
}

