/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassLookupSupport {
    private static HashMap<Class<?>, List<Class<?>>> classSearchOrderLookup;

    public static Class<?>[] getTypeHierarchyFlattened(Class<?> type) {
        List<Class<?>> classes = null;
        HashMap<Class<Object>, List<Class<Object>>> lookup = classSearchOrderLookup;
        if (lookup != null) {
            classes = lookup.get(type);
        }
        if (classes == null) {
            classes = new ArrayList();
            ClassLookupSupport.computeClassOrder(type, classes);
            if (lookup == null) {
                lookup = new HashMap();
                classSearchOrderLookup = lookup;
            }
            lookup.put(type, classes);
        }
        return (Class[])classes.toArray(Class[]::new);
    }

    private static void computeClassOrder(Class<?> adaptable, Collection<Class<?>> classes) {
        Class<Object> clazz = adaptable;
        HashSet seen = new HashSet(4);
        while (clazz != null) {
            classes.add(clazz);
            ClassLookupSupport.computeInterfaceOrder(clazz.getInterfaces(), classes, seen);
            Class clazz2 = clazz = clazz.isInterface() ? Object.class : clazz.getSuperclass();
        }
    }

    private static void computeInterfaceOrder(Class<?>[] interfaces, Collection<Class<?>> classes, Set<Class<?>> seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(interfaces.length);
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class interfaze = classArray[n2];
            if (seen.add(interfaze)) {
                classes.add(interfaze);
                newInterfaces.add(interfaze);
            }
            ++n2;
        }
        for (Class interfaze : newInterfaces) {
            ClassLookupSupport.computeInterfaceOrder(interfaze.getInterfaces(), classes, seen);
        }
    }
}

