/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.internal.services.WorkbenchServiceRegistry;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.services.ISourceProviderService;

public final class SourceProviderService
implements ISourceProviderService,
IDisposable {
    private final Map<String, ISourceProvider> sourceProvidersByName = new HashMap<String, ISourceProvider>();
    private final Set<ISourceProvider> sourceProviders = new HashSet<ISourceProvider>();
    private IServiceLocator locator;

    public SourceProviderService(IServiceLocator locator) {
        this.locator = locator;
    }

    @Override
    public void dispose() {
        for (ISourceProvider sourceProvider : this.sourceProviders) {
            sourceProvider.dispose();
        }
        this.sourceProviders.clear();
        this.sourceProvidersByName.clear();
    }

    @Override
    public ISourceProvider getSourceProvider(String sourceName) {
        return this.sourceProvidersByName.get(sourceName);
    }

    @Override
    public ISourceProvider[] getSourceProviders() {
        return this.sourceProviders.toArray(new ISourceProvider[this.sourceProviders.size()]);
    }

    public void registerProvider(ISourceProvider sourceProvider) {
        if (sourceProvider == null) {
            throw new NullPointerException("The source provider cannot be null");
        }
        String[] stringArray = sourceProvider.getProvidedSourceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceName = stringArray[n2];
            this.sourceProvidersByName.put(sourceName, sourceProvider);
            ++n2;
        }
        this.sourceProviders.add(sourceProvider);
    }

    public void unregisterProvider(ISourceProvider sourceProvider) {
        if (sourceProvider == null) {
            throw new NullPointerException("The source provider cannot be null");
        }
        String[] stringArray = sourceProvider.getProvidedSourceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceName = stringArray[n2];
            this.sourceProvidersByName.remove(sourceName);
            ++n2;
        }
        this.sourceProviders.remove(sourceProvider);
    }

    public void readRegistry() {
        AbstractSourceProvider[] abstractSourceProviderArray = WorkbenchServiceRegistry.getRegistry().getSourceProviders();
        int n = abstractSourceProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractSourceProvider sourceProvider = abstractSourceProviderArray[n2];
            sourceProvider.initialize(this.locator);
            this.registerProvider(sourceProvider);
            ++n2;
        }
    }
}

