/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.sql.Ref;
import java.sql.SQLException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDReference;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCReference
implements DBDReference {
    private static final Log log = Log.getLog(JDBCReference.class);
    private DBSDataType type;
    private Object value;
    private Object refObject;

    public JDBCReference(DBSDataType type, Object value) throws DBCException {
        this.type = type;
        this.value = value;
    }

    public Object getValue() throws DBCException {
        return this.value;
    }

    public Object getRawValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
        this.type = null;
        this.value = null;
    }

    public DBSDataType getReferencedType() {
        return this.type;
    }

    public Object getReferencedObject(DBCSession session) throws DBCException {
        Object object;
        if (this.refObject == null && (object = this.value) instanceof Ref) {
            Ref ref = (Ref)object;
            try {
                DBRProgressMonitor monitor = session.getProgressMonitor();
                monitor.subTask("Read reference '" + this.type.getName() + "'");
                Object refValue = ref.getObject();
                DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)this.type);
                this.refObject = valueHandler.getValueFromObject(session, (DBSTypedObject)this.type, refValue, false, false);
            }
            catch (SQLException sQLException) {
                throw new DBCException("Can't obtain object reference");
            }
        }
        return this.refObject;
    }

    public String toString() {
        try {
            return this.value == null ? "[NULL]" : (this.value instanceof Ref ? ((Ref)this.value).getBaseTypeName() : this.value.toString());
        }
        catch (SQLException sQLException) {
            return this.value.toString();
        }
    }
}

