/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.model;

import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.validator.IntegerValidator;
import org.jkiss.utils.CommonUtils;

public class ContextWindowSizeField {
    @NotNull
    private final Text text;
    private Integer value;

    private ContextWindowSizeField(@NotNull Text text) {
        this.text = text;
        this.text.addModifyListener(e -> {
            Integer n = this.value = CommonUtils.toInteger((Object)text.getText(), null);
        });
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public void setValue(@Nullable Integer value) {
        this.text.setText(value == null ? "" : value.toString());
        this.value = value;
    }

    @Nullable
    public Integer getValue() {
        return this.value;
    }

    public boolean isComplete() {
        return CommonUtils.toInt((Object)this.text.getText(), (int)0) > 0;
    }

    public static class Builder {
        @NotNull
        private Composite parent;
        @NotNull
        private GridData gridData;

        public Builder withParent(@NotNull Composite parent) {
            this.parent = parent;
            return this;
        }

        public Builder withGridData(@NotNull GridData gridData) {
            this.gridData = gridData;
            return this;
        }

        public ContextWindowSizeField build() {
            Text text = UIUtils.createLabelText((Composite)this.parent, (String)"Context window size", (String)"", (int)2048);
            text.addVerifyListener((VerifyListener)new IntegerValidator(1, Integer.MAX_VALUE));
            text.setLayoutData((Object)this.gridData);
            return new ContextWindowSizeField(text);
        }
    }
}

