﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>

namespace Aws {
namespace imagebuilder {
namespace Model {
enum class ComponentStatus { NOT_SET, DEPRECATED, DISABLED, ACTIVE };

namespace ComponentStatusMapper {
AWS_IMAGEBUILDER_API ComponentStatus GetComponentStatusForName(const Aws::String& name);

AWS_IMAGEBUILDER_API Aws::String GetNameForComponentStatus(ComponentStatus value);
}  // namespace ComponentStatusMapper
}  // namespace Model
}  // namespace imagebuilder
}  // namespace Aws
