/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.nlctdoc;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXFontFamily;
import com.dickimawbooks.texparserlib.TeXFontShape;
import com.dickimawbooks.texparserlib.TeXFontText;
import com.dickimawbooks.texparserlib.TeXFontWeight;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.nlctdoc.UserGuideSty;
import java.awt.Color;
import java.io.IOException;

public class DefSemanticCmd
extends ControlSequence {
    private UserGuideSty sty;

    public DefSemanticCmd(UserGuideSty userGuideSty) {
        this("defsemanticcmd", userGuideSty);
    }

    public DefSemanticCmd(String string, UserGuideSty userGuideSty) {
        super(string);
        this.sty = userGuideSty;
    }

    @Override
    public Object clone() {
        return new DefSemanticCmd(this.getName(), this.sty);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        String string = this.popOptLabelString(teXParser, teXObjectList);
        Color color = null;
        if (string != null && !string.isEmpty()) {
            object = string.contains(",") ? "rgb" : "named";
            color = this.sty.getColorSty().getColor(teXParser, (String)object, string);
        }
        object = this.popControlSequence(teXParser, teXObjectList);
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        ControlSequence controlSequence = null;
        if (!teXObject.isEmpty()) {
            if (teXObject instanceof ControlSequence) {
                controlSequence = (ControlSequence)teXObject;
            } else if (teXParser.isStack(teXObject)) {
                controlSequence = this.popControlSequence(teXParser, (TeXObjectList)teXObject);
            }
        }
        TeXObject teXObject2 = this.popArg(teXParser, teXObjectList);
        TeXFontText teXFontText = null;
        if (controlSequence != null) {
            teXFontText = new TeXFontText();
            if (controlSequence.getName().equals("texttt")) {
                teXFontText.setFamily(TeXFontFamily.VERB);
            } else if (controlSequence.getName().equals("textsf")) {
                teXFontText.setFamily(TeXFontFamily.SF);
            } else if (controlSequence.getName().equals("textit")) {
                teXFontText.setShape(TeXFontShape.IT);
            } else if (controlSequence.getName().equals("textsc")) {
                teXFontText.setShape(TeXFontShape.SC);
            } else if (controlSequence.getName().equals("emph")) {
                teXFontText.setShape(TeXFontShape.EM);
            } else if (controlSequence.getName().equals("textbf")) {
                teXFontText.setWeight(TeXFontWeight.BF);
            }
        }
        this.sty.addSemanticCommand(((ControlSequence)object).getName(), teXFontText, color, teXObject2, null);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

