/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.util.IOTools;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.tomcat.util.res.StringManager;

public class ExtractingRoot
extends StandardRoot {
    private static final StringManager sm = StringManager.getManager(ExtractingRoot.class);
    private static final String APPLICATION_JARS_DIR = "application-jars";

    @Override
    protected void processWebInfLib() throws LifecycleException {
        WebResource[] webResourceArray;
        if (!super.isPackedWarFile()) {
            super.processWebInfLib();
            return;
        }
        File file = this.getExpansionTarget();
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new LifecycleException(sm.getString("extractingRoot.targetFailed", new Object[]{file}));
        }
        for (WebResource webResource : webResourceArray = this.listResources("/WEB-INF/lib", false)) {
            if (!webResource.isFile() || !webResource.getName().endsWith(".jar")) continue;
            try {
                File file2 = new File(file, webResource.getName());
                file2 = file2.getCanonicalFile();
                try (InputStream inputStream = webResource.getInputStream();
                     FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                    IOTools.flow(inputStream, fileOutputStream);
                }
                this.createWebResourceSet(WebResourceRoot.ResourceSetType.CLASSES_JAR, "/WEB-INF/classes", file2.toURI().toURL(), "/");
            }
            catch (IOException iOException) {
                throw new LifecycleException(sm.getString("extractingRoot.jarFailed", new Object[]{webResource.getName()}), iOException);
            }
        }
    }

    private File getExpansionTarget() {
        File file = (File)this.getContext().getServletContext().getAttribute("javax.servlet.context.tempdir");
        return new File(file, APPLICATION_JARS_DIR);
    }

    @Override
    protected boolean isPackedWarFile() {
        return false;
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (super.isPackedWarFile()) {
            File file = this.getExpansionTarget();
            ExpandWar.delete(file);
        }
    }
}

