/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.MemorySegmentIndexInput;
import org.apache.lucene.store.NativeAccess;
import org.apache.lucene.store.RefCountedSharedArena;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.Unwrappable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class MemorySegmentIndexInputProvider
implements MMapDirectory.MMapIndexInputProvider<ConcurrentHashMap<String, RefCountedSharedArena>> {
    private final Optional<NativeAccess> nativeAccess = NativeAccess.getImplementation();
    private final int sharedArenaMaxPermits;

    public MemorySegmentIndexInputProvider(int maxPermits) {
        this.sharedArenaMaxPermits = MemorySegmentIndexInputProvider.checkMaxPermits(maxPermits);
        Logger log = Logger.getLogger(this.getClass().getName());
        log.info(String.format(Locale.ENGLISH, "Using MemorySegmentIndexInput%s with Java 21 or later; to disable start with -D%s=false", this.nativeAccess.map(n -> " and native madvise support").orElse(""), "org.apache.lucene.store.MMapDirectory.enableMemorySegments"));
    }

    @Override
    public IndexInput openInput(Path path, IOContext context, int chunkSizePower, boolean preload, Optional<String> group, ConcurrentHashMap<String, RefCountedSharedArena> arenas) throws IOException {
        String resourceDescription = "MemorySegmentIndexInput(path=\"" + path.toString() + "\")";
        path = Unwrappable.unwrapAll(path);
        boolean success = false;
        boolean confined = context == IOContext.READONCE;
        Arena arena = confined ? Arena.ofConfined() : this.getSharedArena(group, arenas);
        try {
            MemorySegmentIndexInput memorySegmentIndexInput;
            block10: {
                FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);
                try {
                    long fileSize = fc.size();
                    MemorySegmentIndexInput in = MemorySegmentIndexInput.newInstance(resourceDescription, arena, this.map(arena, resourceDescription, fc, context, chunkSizePower, preload, fileSize), fileSize, chunkSizePower, confined);
                    success = true;
                    memorySegmentIndexInput = in;
                    if (fc == null) break block10;
                }
                catch (Throwable throwable) {
                    if (fc != null) {
                        try {
                            fc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fc.close();
            }
            return memorySegmentIndexInput;
        }
        finally {
            if (!success) {
                arena.close();
            }
        }
    }

    @Override
    public long getDefaultMaxChunkSize() {
        return Constants.JRE_IS_64BIT ? 0x400000000L : 0x10000000L;
    }

    @Override
    public boolean isUnmapSupported() {
        return true;
    }

    @Override
    public String getUnmapNotSupportedReason() {
        return null;
    }

    @Override
    public boolean supportsMadvise() {
        return this.nativeAccess.isPresent();
    }

    private final MemorySegment[] map(Arena arena, String resourceDescription, FileChannel fc, IOContext context, int chunkSizePower, boolean preload, long length) throws IOException {
        if (length >>> chunkSizePower >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big for chunk size: " + resourceDescription);
        }
        long chunkSize = 1L << chunkSizePower;
        int nrSegments = (int)(length >>> chunkSizePower) + 1;
        MemorySegment[] segments = new MemorySegment[nrSegments];
        long startOffset = 0L;
        for (int segNr = 0; segNr < nrSegments; ++segNr) {
            MemorySegment segment;
            long segSize = length > startOffset + chunkSize ? chunkSize : length - startOffset;
            try {
                segment = fc.map(FileChannel.MapMode.READ_ONLY, startOffset, segSize, arena);
            }
            catch (IOException ioe) {
                throw this.convertMapFailedIOException(ioe, resourceDescription, segSize);
            }
            if (preload) {
                segment.load();
            } else if (this.nativeAccess.isPresent() && chunkSizePower >= 21) {
                this.nativeAccess.get().madvise(segment, context);
            }
            segments[segNr] = segment;
            startOffset += segSize;
        }
        return segments;
    }

    @Override
    public ConcurrentHashMap<String, RefCountedSharedArena> attachment() {
        return new ConcurrentHashMap<String, RefCountedSharedArena>();
    }

    private static int checkMaxPermits(int maxPermits) {
        if (RefCountedSharedArena.validMaxPermits(maxPermits)) {
            return maxPermits;
        }
        Logger.getLogger(MemorySegmentIndexInputProvider.class.getName()).warning("Invalid value for sysprop org.apache.lucene.store.MMapDirectory.sharedArenaMaxPermits, must be positive and <= 0x07FF. The default value will be used.");
        return 64;
    }

    private Arena getSharedArena(Optional<String> group, ConcurrentHashMap<String, RefCountedSharedArena> arenas) {
        if (group.isEmpty()) {
            return Arena.ofShared();
        }
        String key = group.get();
        RefCountedSharedArena refCountedArena = arenas.computeIfAbsent(key, s -> new RefCountedSharedArena((String)s, () -> arenas.remove(s), this.sharedArenaMaxPermits));
        if (refCountedArena.acquire()) {
            return refCountedArena;
        }
        return arenas.compute(key, (s, v) -> {
            if (v != null && v.acquire()) {
                return v;
            }
            v = new RefCountedSharedArena((String)s, () -> arenas.remove(s), this.sharedArenaMaxPermits);
            v.acquire();
            return v;
        });
    }
}

