/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core;

import java.io.InputStream;
import java.io.Reader;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.TreeNode;
import tools.jackson.core.tree.ArrayTreeNode;
import tools.jackson.core.tree.ObjectTreeNode;
import tools.jackson.core.type.ResolvedType;
import tools.jackson.core.type.TypeReference;

public interface ObjectReadContext {
    public static ObjectReadContext empty() {
        return Base.EMPTY_CONTEXT;
    }

    public FormatSchema getSchema();

    public int getStreamReadFeatures(int var1);

    public int getFormatReadFeatures(int var1);

    public TokenStreamFactory tokenStreamFactory();

    public StreamReadConstraints streamReadConstraints();

    default public JsonParser createParser(InputStream in) throws JacksonException {
        return this.tokenStreamFactory().createParser(this, in);
    }

    default public JsonParser createParser(Reader r) throws JacksonException {
        return this.tokenStreamFactory().createParser(this, r);
    }

    default public JsonParser createParser(String content) throws JacksonException {
        return this.tokenStreamFactory().createParser(this, content);
    }

    default public JsonParser createParser(byte[] content) throws JacksonException {
        return this.tokenStreamFactory().createParser(this, content);
    }

    default public JsonParser createParser(byte[] content, int offset, int length) throws JacksonException {
        return this.tokenStreamFactory().createParser(this, content, offset, length);
    }

    public ArrayTreeNode createArrayNode();

    public ObjectTreeNode createObjectNode();

    public <T extends TreeNode> T readTree(JsonParser var1) throws JacksonException;

    default public JsonParser treeAsTokens(TreeNode n) {
        return n.traverse(this);
    }

    public <T> T readValue(JsonParser var1, Class<T> var2) throws JacksonException;

    public <T> T readValue(JsonParser var1, TypeReference<T> var2) throws JacksonException;

    public <T> T readValue(JsonParser var1, ResolvedType var2) throws JacksonException;

    public static class Base
    implements ObjectReadContext {
        protected static Base EMPTY_CONTEXT = new Base();

        @Override
        public FormatSchema getSchema() {
            return null;
        }

        @Override
        public StreamReadConstraints streamReadConstraints() {
            return StreamReadConstraints.defaults();
        }

        @Override
        public int getStreamReadFeatures(int defaults) {
            return defaults;
        }

        @Override
        public int getFormatReadFeatures(int defaults) {
            return defaults;
        }

        @Override
        public TokenStreamFactory tokenStreamFactory() {
            return (TokenStreamFactory)this._reportUnsupportedOperation();
        }

        @Override
        public ObjectTreeNode createObjectNode() {
            return (ObjectTreeNode)this._reportUnsupportedOperation();
        }

        @Override
        public ArrayTreeNode createArrayNode() {
            return (ArrayTreeNode)this._reportUnsupportedOperation();
        }

        @Override
        public <T extends TreeNode> T readTree(JsonParser p) {
            return (T)((TreeNode)this._reportUnsupportedOperation());
        }

        @Override
        public <T> T readValue(JsonParser p, Class<T> valueType) {
            return this._reportUnsupportedOperation();
        }

        @Override
        public <T> T readValue(JsonParser p, TypeReference<T> valueTypeRef) {
            return this._reportUnsupportedOperation();
        }

        @Override
        public <T> T readValue(JsonParser p, ResolvedType type) {
            return this._reportUnsupportedOperation();
        }

        protected <T> T _reportUnsupportedOperation() {
            throw new UnsupportedOperationException("Operation not supported by `ObjectReadContext` of type " + this.getClass().getName());
        }
    }
}

