/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.sql.SQLException;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AsyncFetchStatus {
    public boolean isPending();

    default public Optional<SQLException> exception() {
        return Optional.empty();
    }

    public static AsyncFetchStatus nonePending() {
        return NonePending.INSTANCE;
    }

    public static AsyncFetchStatus pending() {
        return Pending.INSTANCE;
    }

    public static AsyncFetchStatus completed() {
        return AsyncFetchStatus.nonePending();
    }

    public static AsyncFetchStatus completedWithException(SQLException exception) {
        return new CompletedWithException(exception);
    }

    public static final class NonePending
    implements AsyncFetchStatus {
        private static final NonePending INSTANCE = new NonePending();

        private NonePending() {
        }

        @Override
        public boolean isPending() {
            return false;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static class Pending
    implements AsyncFetchStatus {
        private static final Pending INSTANCE = new Pending();

        private Pending() {
        }

        @Override
        public final boolean isPending() {
            return true;
        }
    }

    public static final class CompletedWithException
    extends Pending {
        private final SQLException completionException;

        private CompletedWithException(SQLException completionException) {
            this.completionException = completionException;
        }

        @Override
        public Optional<SQLException> exception() {
            return Optional.of(this.completionException);
        }
    }
}

