/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import org.ldaptive.Response;
import org.ldaptive.SearchEntry;
import org.ldaptive.async.AsyncRequest;
import org.ldaptive.control.EntryChangeNotificationControl;

public class PersistentSearchItem {
    private final AsyncRequest asyncRequest;
    private final Entry persistentSearchEntry;
    private final Response persistentSearchResponse;
    private final Exception persistentSearchException;

    public PersistentSearchItem(AsyncRequest request) {
        this.asyncRequest = request;
        this.persistentSearchEntry = null;
        this.persistentSearchResponse = null;
        this.persistentSearchException = null;
    }

    public PersistentSearchItem(Entry entry) {
        this.asyncRequest = null;
        this.persistentSearchEntry = entry;
        this.persistentSearchResponse = null;
        this.persistentSearchException = null;
    }

    public PersistentSearchItem(Response response) {
        this.asyncRequest = null;
        this.persistentSearchEntry = null;
        this.persistentSearchResponse = response;
        this.persistentSearchException = null;
    }

    public PersistentSearchItem(Exception exception) {
        this.asyncRequest = null;
        this.persistentSearchEntry = null;
        this.persistentSearchResponse = null;
        this.persistentSearchException = exception;
    }

    public boolean isAsyncRequest() {
        return this.asyncRequest != null;
    }

    public AsyncRequest getAsyncRequest() {
        return this.asyncRequest;
    }

    public boolean isEntry() {
        return this.persistentSearchEntry != null;
    }

    public Entry getEntry() {
        return this.persistentSearchEntry;
    }

    public boolean isResponse() {
        return this.persistentSearchResponse != null;
    }

    public Response getResponse() {
        return this.persistentSearchResponse;
    }

    public boolean isException() {
        return this.persistentSearchException != null;
    }

    public Exception getException() {
        return this.persistentSearchException;
    }

    public String toString() {
        String s = this.isAsyncRequest() ? String.format("[%s@%d::asyncRequest=%s]", this.getClass().getName(), this.hashCode(), this.asyncRequest) : (this.isEntry() ? String.format("[%s@%d::persistentSearchEntry=%s]", this.getClass().getName(), this.hashCode(), this.persistentSearchEntry) : (this.isResponse() ? String.format("[%s@%d::persistentSearchResponse=%s]", this.getClass().getName(), this.hashCode(), this.persistentSearchResponse) : (this.isException() ? String.format("[%s@%d::persistentSearchException=%s]", this.getClass().getName(), this.hashCode(), this.persistentSearchException) : String.format("[%s@%d]", this.getClass().getName(), this.hashCode()))));
        return s;
    }

    public static class Entry {
        private final SearchEntry searchEntry;
        private final EntryChangeNotificationControl entryChangeNotificationControl;

        public Entry(SearchEntry entry) {
            this.searchEntry = entry;
            this.entryChangeNotificationControl = (EntryChangeNotificationControl)entry.getControl("2.16.840.1.113730.3.4.7");
        }

        public SearchEntry getSearchEntry() {
            return this.searchEntry;
        }

        public EntryChangeNotificationControl getEntryChangeNotificationControl() {
            return this.entryChangeNotificationControl;
        }

        public String toString() {
            return String.format("[%s@%d::searchEntry=%s]", this.getClass().getName(), this.hashCode(), this.searchEntry);
        }
    }
}

