/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.criteria.entity.impl;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.criteria.entity.EvaluableEntityDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;

public class EvaluableEntityRoleEntityDescriptorCriterion
implements EvaluableEntityDescriptorCriterion {
    @Nonnull
    private QName role;

    public EvaluableEntityRoleEntityDescriptorCriterion(@Nonnull EntityRoleCriterion criterion) {
        Constraint.isNotNull(criterion, "EntityRoleCriterion was null");
        this.role = Constraint.isNotNull(criterion.getRole(), "Criterion role QName was null");
    }

    public EvaluableEntityRoleEntityDescriptorCriterion(@Nonnull QName entityRole) {
        this.role = Constraint.isNotNull(entityRole, "Entity Role QName was null");
    }

    @Override
    public boolean test(@Nullable EntityDescriptor entityDescriptor) {
        if (entityDescriptor == null) {
            return false;
        }
        return !entityDescriptor.getRoleDescriptors(this.role).isEmpty();
    }

    public int hashCode() {
        return this.role.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EvaluableEntityRoleEntityDescriptorCriterion) {
            EvaluableEntityRoleEntityDescriptorCriterion other = (EvaluableEntityRoleEntityDescriptorCriterion)obj;
            return Objects.equals(this.role, other.role);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("role", (Object)this.role).toString();
    }
}

