/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.stats.eval.impl;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.commons.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.commons.stats.eval.impl.IStatistic;
import org.opensearch.performanceanalyzer.commons.stats.eval.impl.vals.AggregateValue;

public class Mean
implements IStatistic<AggregateValue> {
    private BigInteger sum = BigInteger.ZERO;
    private long count = 0L;
    private boolean empty = true;

    @Override
    public Statistics type() {
        return Statistics.MEAN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculate(String key, Number value) {
        Mean mean = this;
        synchronized (mean) {
            BigInteger bdValue = BigInteger.valueOf(value.longValue());
            this.sum = this.sum.add(bdValue);
            ++this.count;
        }
        this.empty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AggregateValue> get() {
        double ret = 0.0;
        Mean mean = this;
        synchronized (mean) {
            if (this.count != 0L) {
                ret = this.sum.doubleValue() / (double)this.count;
            }
        }
        return Collections.singletonList(new AggregateValue(ret, this.type()));
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }
}

