/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.crypto.util.DerUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public final class ByteMacData {
    private final byte[] macData;

    private ByteMacData(byte[] byArray) {
        this.macData = byArray;
    }

    public byte[] getMacData() {
        return Arrays.clone(this.macData);
    }

    public static final class Builder {
        private final Type type;
        private byte[] idU;
        private byte[] idV;
        private byte[] ephemDataU;
        private byte[] ephemDataV;
        private byte[] text;

        public Builder(Type type, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
            this.type = type;
            this.idU = Arrays.clone(byArray);
            this.idV = Arrays.clone(byArray2);
            this.ephemDataU = Arrays.clone(byArray3);
            this.ephemDataV = Arrays.clone(byArray4);
        }

        public Builder withText(byte[] byArray) {
            this.text = DerUtil.toByteArray(new DERTaggedObject(false, 0, DerUtil.getOctetString(byArray)));
            return this;
        }

        public ByteMacData build() {
            switch (this.type) {
                case UNILATERALU: 
                case BILATERALU: {
                    return new ByteMacData(this.concatenate(this.type.getHeader(), this.idU, this.idV, this.ephemDataU, this.ephemDataV, this.text));
                }
                case UNILATERALV: 
                case BILATERALV: {
                    return new ByteMacData(this.concatenate(this.type.getHeader(), this.idV, this.idU, this.ephemDataV, this.ephemDataU, this.text));
                }
            }
            throw new IllegalStateException("Unknown type encountered in build");
        }

        private byte[] concatenate(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
            return Arrays.concatenate(Arrays.concatenate(byArray, byArray2, byArray3), Arrays.concatenate(byArray4, byArray5, byArray6));
        }
    }

    public static enum Type {
        UNILATERALU("KC_1_U"),
        UNILATERALV("KC_1_V"),
        BILATERALU("KC_2_U"),
        BILATERALV("KC_2_V");

        private final String enc;

        private Type(String string2) {
            this.enc = string2;
        }

        public byte[] getHeader() {
            return Strings.toByteArray(this.enc);
        }
    }
}

