/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.DataPathStats;
import org.opensearch.client.opensearch.nodes.stats.FileSystemTotal;
import org.opensearch.client.opensearch.nodes.stats.IoStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FileSystem
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, FileSystem> {
    @Nonnull
    private final List<DataPathStats> data;
    @Nullable
    private final IoStats ioStats;
    @Nullable
    private final Long timestamp;
    @Nullable
    private final FileSystemTotal total;
    public static final JsonpDeserializer<FileSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileSystem::setupFileSystemDeserializer);

    private FileSystem(Builder builder) {
        this.data = ApiTypeHelper.unmodifiable(builder.data);
        this.ioStats = builder.ioStats;
        this.timestamp = builder.timestamp;
        this.total = builder.total;
    }

    public static FileSystem of(Function<Builder, ObjectBuilder<FileSystem>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<DataPathStats> data() {
        return this.data;
    }

    @Nullable
    public final IoStats ioStats() {
        return this.ioStats;
    }

    @Nullable
    public final Long timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final FileSystemTotal total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.data)) {
            generator.writeKey("data");
            generator.writeStartArray();
            for (DataPathStats item0 : this.data) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ioStats != null) {
            generator.writeKey("io_stats");
            this.ioStats.serialize(generator, mapper);
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp.longValue());
        }
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFileSystemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::data, JsonpDeserializer.arrayDeserializer(DataPathStats._DESERIALIZER), "data");
        op.add(Builder::ioStats, IoStats._DESERIALIZER, "io_stats");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::total, FileSystemTotal._DESERIALIZER, "total");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.data);
        result = 31 * result + Objects.hashCode(this.ioStats);
        result = 31 * result + Objects.hashCode(this.timestamp);
        result = 31 * result + Objects.hashCode(this.total);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystem other = (FileSystem)o;
        return Objects.equals(this.data, other.data) && Objects.equals(this.ioStats, other.ioStats) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.total, other.total);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, FileSystem> {
        @Nullable
        private List<DataPathStats> data;
        @Nullable
        private IoStats ioStats;
        @Nullable
        private Long timestamp;
        @Nullable
        private FileSystemTotal total;

        public Builder() {
        }

        private Builder(FileSystem o) {
            this.data = Builder._listCopy(o.data);
            this.ioStats = o.ioStats;
            this.timestamp = o.timestamp;
            this.total = o.total;
        }

        private Builder(Builder o) {
            this.data = Builder._listCopy(o.data);
            this.ioStats = o.ioStats;
            this.timestamp = o.timestamp;
            this.total = o.total;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder data(List<DataPathStats> list) {
            this.data = Builder._listAddAll(this.data, list);
            return this;
        }

        @Nonnull
        public final Builder data(DataPathStats value, DataPathStats ... values) {
            this.data = Builder._listAdd(this.data, value, values);
            return this;
        }

        @Nonnull
        public final Builder data(Function<DataPathStats.Builder, ObjectBuilder<DataPathStats>> fn) {
            return this.data(fn.apply(new DataPathStats.Builder()).build(), new DataPathStats[0]);
        }

        @Nonnull
        public final Builder ioStats(@Nullable IoStats value) {
            this.ioStats = value;
            return this;
        }

        @Nonnull
        public final Builder ioStats(Function<IoStats.Builder, ObjectBuilder<IoStats>> fn) {
            return this.ioStats(fn.apply(new IoStats.Builder()).build());
        }

        @Nonnull
        public final Builder timestamp(@Nullable Long value) {
            this.timestamp = value;
            return this;
        }

        @Nonnull
        public final Builder total(@Nullable FileSystemTotal value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder total(Function<FileSystemTotal.Builder, ObjectBuilder<FileSystemTotal>> fn) {
            return this.total(fn.apply(new FileSystemTotal.Builder()).build());
        }

        @Override
        @Nonnull
        public FileSystem build() {
            this._checkSingleUse();
            return new FileSystem(this);
        }
    }
}

