/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.remote.metadata.client.AbstractSdkClient;
import org.opensearch.remote.metadata.client.BulkDataObjectRequest;
import org.opensearch.remote.metadata.client.BulkDataObjectResponse;
import org.opensearch.remote.metadata.client.DataObjectRequest;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.GetDataObjectResponse;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.PutDataObjectResponse;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.client.SearchDataObjectResponse;
import org.opensearch.remote.metadata.client.UpdateDataObjectRequest;
import org.opensearch.remote.metadata.client.UpdateDataObjectResponse;
import org.opensearch.remote.metadata.client.WriteDataObjectRequest;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.secure_sm.AccessController;
import org.opensearch.transport.client.Client;

public class LocalClusterIndicesClient
extends AbstractSdkClient {
    private static final Logger log = LogManager.getLogger(LocalClusterIndicesClient.class);
    private final Client client;

    @Override
    public boolean supportsMetadataType(String metadataType) {
        return Strings.isNullOrEmpty((String)metadataType);
    }

    public LocalClusterIndicesClient(Client client, NamedXContentRegistry xContentRegistry, Map<String, String> metadataSettings) {
        super.initialize(metadataSettings);
        this.client = client;
    }

    @Override
    public CompletionStage<PutDataObjectResponse> putDataObjectAsync(PutDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        CompletableFuture future = new CompletableFuture();
        return (CompletionStage)AccessController.doPrivileged(() -> {
            try {
                log.info("Indexing data object in {}", (Object)request.index());
                IndexRequest indexRequest = this.createIndexRequest(request);
                this.client.index(indexRequest, ActionListener.wrap(indexResponse -> {
                    log.info("Creation status for id {}: {}", (Object)indexResponse.getId(), (Object)indexResponse.getResult());
                    future.complete(new PutDataObjectResponse((IndexResponse)indexResponse));
                }, e -> {
                    Throwable t = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (t instanceof VersionConflictEngineException) {
                        log.error("Document version conflict putting {} in {}: {}", (Object)request.id(), (Object)request.index(), (Object)e.getMessage(), e);
                        future.completeExceptionally((Throwable)new OpenSearchStatusException("Document version conflict putting " + request.id() + " in index " + request.index(), RestStatus.CONFLICT, t, new Object[0]));
                    } else {
                        future.completeExceptionally((Throwable)new OpenSearchStatusException("Failed to put data object in index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]));
                    }
                }));
            }
            catch (IOException e2) {
                future.completeExceptionally((Throwable)new OpenSearchStatusException("Failed to parse data object to put in index " + request.index(), RestStatus.BAD_REQUEST, (Throwable)e2, new Object[0]));
            }
            return future;
        });
    }

    private IndexRequest createIndexRequest(PutDataObjectRequest putDataObjectRequest) throws IOException {
        try (XContentBuilder sourceBuilder = XContentFactory.jsonBuilder();){
            IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(putDataObjectRequest.index()).opType(putDataObjectRequest.overwriteIfExists() ? DocWriteRequest.OpType.INDEX : DocWriteRequest.OpType.CREATE).source(putDataObjectRequest.dataObject().toXContent(sourceBuilder, ToXContent.EMPTY_PARAMS)).setRefreshPolicy(putDataObjectRequest.getRefreshPolicy())).timeout(putDataObjectRequest.timeout());
            if (this.shouldUseId(putDataObjectRequest.id())) {
                indexRequest.id(putDataObjectRequest.id());
            }
            IndexRequest indexRequest2 = this.setSeqNoAndPrimaryTerm(indexRequest, putDataObjectRequest);
            return indexRequest2;
        }
    }

    private <T extends DocWriteRequest<T>, R extends WriteDataObjectRequest<R>> T setSeqNoAndPrimaryTerm(T request, R writeRequest) {
        if (writeRequest.ifSeqNo() != null) {
            request.setIfSeqNo(writeRequest.ifSeqNo().longValue());
        }
        if (writeRequest.ifPrimaryTerm() != null) {
            request.setIfPrimaryTerm(writeRequest.ifPrimaryTerm().longValue());
        }
        return request;
    }

    @Override
    public CompletionStage<GetDataObjectResponse> getDataObjectAsync(GetDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        return (CompletionStage)AccessController.doPrivileged(() -> {
            if (Boolean.FALSE.equals(isMultiTenancyEnabled) || Strings.isNullOrEmpty((String)this.globalTenantId)) {
                return this.innerGetDataObjectAsync(request, executor, isMultiTenancyEnabled);
            }
            GetDataObjectResponse cachedResponse = this.getGlobalResourceDataFromCache(request);
            if (cachedResponse != null) {
                return CompletableFuture.completedFuture(cachedResponse);
            }
            CompletionStage<GetDataObjectResponse> dataFetched = this.innerGetDataObjectAsync(request, executor, isMultiTenancyEnabled);
            return this.handleOSDocumentBasedResponse(request, dataFetched);
        });
    }

    @Override
    protected CompletionStage<GetDataObjectResponse> innerGetDataObjectAsync(GetDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        CompletableFuture future = new CompletableFuture();
        return (CompletionStage)AccessController.doPrivileged(() -> {
            GetRequest getRequest = this.createGetRequest(request);
            this.client.get(getRequest, ActionListener.wrap(getResponse -> future.complete(new GetDataObjectResponse((GetResponse)getResponse)), e -> future.completeExceptionally((Throwable)new OpenSearchStatusException("Failed to get data object from index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]))));
            return future;
        });
    }

    private GetRequest createGetRequest(GetDataObjectRequest request) {
        return new GetRequest(request.index(), request.id()).fetchSourceContext(request.fetchSourceContext());
    }

    @Override
    public CompletionStage<UpdateDataObjectResponse> updateDataObjectAsync(UpdateDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        CompletableFuture future = new CompletableFuture();
        return (CompletionStage)AccessController.doPrivileged(() -> {
            try {
                log.info("Updating {} from {}", (Object)request.id(), (Object)request.index());
                UpdateRequest updateRequest = this.createUpdateRequest(request);
                this.client.update(updateRequest, ActionListener.wrap(updateResponse -> {
                    if (updateResponse == null) {
                        log.info("Null UpdateResponse");
                        future.complete(((UpdateDataObjectResponse.Builder)((UpdateDataObjectResponse.Builder)UpdateDataObjectResponse.builder().id(request.id())).parser(null)).build());
                    } else {
                        log.info("Update status for id {}: {}", (Object)updateResponse.getId(), (Object)updateResponse.getResult());
                        future.complete(new UpdateDataObjectResponse((UpdateResponse)updateResponse));
                    }
                }, e -> {
                    Throwable t = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (t instanceof VersionConflictEngineException) {
                        log.error("Document version conflict updating {} in {}: {}", (Object)request.id(), (Object)request.index(), (Object)e.getMessage(), e);
                        future.completeExceptionally((Throwable)new OpenSearchStatusException("Document version conflict updating " + request.id() + " in index " + request.index(), RestStatus.CONFLICT, t, new Object[0]));
                    } else {
                        future.completeExceptionally((Throwable)new OpenSearchStatusException("Failed to update data object in index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, t, new Object[0]));
                    }
                }));
            }
            catch (IOException e2) {
                future.completeExceptionally((Throwable)new OpenSearchStatusException("Failed to parse data object to update in index " + request.index(), RestStatus.BAD_REQUEST, (Throwable)e2, new Object[0]));
            }
            return future;
        });
    }

    private UpdateRequest createUpdateRequest(UpdateDataObjectRequest updateDataObjectRequest) throws IOException {
        try (XContentBuilder sourceBuilder = XContentFactory.jsonBuilder();){
            UpdateRequest updateRequest = (UpdateRequest)new UpdateRequest(updateDataObjectRequest.index(), updateDataObjectRequest.id()).doc(updateDataObjectRequest.dataObject().toXContent(sourceBuilder, ToXContent.EMPTY_PARAMS)).setRefreshPolicy(updateDataObjectRequest.getRefreshPolicy()).timeout(updateDataObjectRequest.timeout());
            if (updateDataObjectRequest.retryOnConflict() > 0) {
                updateRequest.retryOnConflict(updateDataObjectRequest.retryOnConflict());
            }
            UpdateRequest updateRequest2 = this.setSeqNoAndPrimaryTerm(updateRequest, updateDataObjectRequest);
            return updateRequest2;
        }
    }

    @Override
    public CompletionStage<DeleteDataObjectResponse> deleteDataObjectAsync(DeleteDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        CompletableFuture future = new CompletableFuture();
        return (CompletionStage)AccessController.doPrivileged(() -> {
            log.info("Deleting {} from {}", (Object)request.id(), (Object)request.index());
            DeleteRequest deleteRequest = this.createDeleteRequest(request);
            this.client.delete(deleteRequest, ActionListener.wrap(deleteResponse -> {
                log.info("Deletion status for id {}: {}", (Object)deleteResponse.getId(), (Object)deleteResponse.getResult());
                future.complete(new DeleteDataObjectResponse((DeleteResponse)deleteResponse));
            }, e -> {
                Throwable t = ExceptionsHelper.unwrapCause((Throwable)e);
                if (t instanceof VersionConflictEngineException) {
                    log.error("Document version conflict deleting {} from {}: {}", (Object)request.id(), (Object)request.index(), (Object)e.getMessage(), e);
                    future.completeExceptionally((Throwable)new OpenSearchStatusException("Document version conflict deleting " + request.id() + " from index " + request.index(), RestStatus.CONFLICT, t, new Object[0]));
                } else {
                    future.completeExceptionally((Throwable)new OpenSearchStatusException("Failed to delete data object from index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]));
                }
            }));
            return future;
        });
    }

    private DeleteRequest createDeleteRequest(DeleteDataObjectRequest deleteDataObjectRequest) {
        DeleteRequest deleteRequest = (DeleteRequest)((DeleteRequest)new DeleteRequest(deleteDataObjectRequest.index(), deleteDataObjectRequest.id()).setRefreshPolicy(deleteDataObjectRequest.getRefreshPolicy())).timeout(deleteDataObjectRequest.timeout());
        return this.setSeqNoAndPrimaryTerm(deleteRequest, deleteDataObjectRequest);
    }

    @Override
    public CompletionStage<BulkDataObjectResponse> bulkDataObjectAsync(BulkDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        CompletableFuture future = new CompletableFuture();
        return (CompletionStage)AccessController.doPrivileged(() -> {
            try {
                log.info("Performing {} bulk actions on indices {}", (Object)request.requests().size(), request.getIndices());
                BulkRequest bulkRequest = new BulkRequest();
                for (DataObjectRequest dataObjectRequest : request.requests()) {
                    if (dataObjectRequest instanceof PutDataObjectRequest) {
                        bulkRequest.add(this.createIndexRequest((PutDataObjectRequest)dataObjectRequest));
                        continue;
                    }
                    if (dataObjectRequest instanceof UpdateDataObjectRequest) {
                        bulkRequest.add(this.createUpdateRequest((UpdateDataObjectRequest)dataObjectRequest));
                        continue;
                    }
                    if (!(dataObjectRequest instanceof DeleteDataObjectRequest)) continue;
                    bulkRequest.add(this.createDeleteRequest((DeleteDataObjectRequest)dataObjectRequest));
                }
                bulkRequest.setRefreshPolicy(request.getRefreshPolicy()).timeout(request.timeout());
                this.client.bulk(bulkRequest, ActionListener.wrap(bulkResponse -> future.complete(new BulkDataObjectResponse((BulkResponse)bulkResponse)), e -> future.completeExceptionally((Throwable)new OpenSearchStatusException("Failed to execute bulk request", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]))));
            }
            catch (IOException e2) {
                future.completeExceptionally((Throwable)new OpenSearchStatusException("Failed to create bulk request", RestStatus.BAD_REQUEST, (Throwable)e2, new Object[0]));
            }
            return future;
        });
    }

    @Override
    public CompletionStage<SearchDataObjectResponse> searchDataObjectAsync(SearchDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        CompletableFuture<SearchDataObjectResponse> future = new CompletableFuture<SearchDataObjectResponse>();
        SearchSourceBuilder searchSource = request.searchSourceBuilder();
        if (Boolean.TRUE.equals(isMultiTenancyEnabled)) {
            if (request.tenantId() == null) {
                future.completeExceptionally((Throwable)new OpenSearchStatusException("Tenant ID is required when multitenancy is enabled.", RestStatus.BAD_REQUEST, new Object[0]));
                return future;
            }
            QueryBuilder existingQuery = searchSource.query();
            TermQueryBuilder tenantIdTermQuery = QueryBuilders.termQuery((String)this.tenantIdField, (String)request.tenantId());
            if (existingQuery == null) {
                searchSource.query((QueryBuilder)tenantIdTermQuery);
            } else {
                BoolQueryBuilder boolQuery = existingQuery instanceof BoolQueryBuilder ? (BoolQueryBuilder)existingQuery : QueryBuilders.boolQuery().must(existingQuery);
                boolQuery.filter((QueryBuilder)tenantIdTermQuery);
                searchSource.query((QueryBuilder)boolQuery);
            }
            log.debug("Adding tenant id to search query");
        }
        log.info("Searching {}", (Object)Arrays.toString(request.indices()));
        return (CompletionStage)AccessController.doPrivileged(() -> {
            SearchRequest searchRequest = new SearchRequest(request.indices(), searchSource);
            this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
                log.info("Search returned {} hits", (Object)searchResponse.getHits().getTotalHits());
                future.complete(new SearchDataObjectResponse((SearchResponse)searchResponse));
            }, e -> future.completeExceptionally((Throwable)new OpenSearchStatusException("Failed to search indices " + Arrays.toString(request.indices()), e instanceof IndexNotFoundException ? RestStatus.NOT_FOUND : RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]))));
            return future;
        });
    }

    @Override
    public void close() throws Exception {
    }
}

