/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.search_pipeline.ResponseProcessor;
import org.opensearch.client.opensearch.search_pipeline.ResponseProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PersonalizeSearchRankingResponseProcessor
implements ResponseProcessorVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, PersonalizeSearchRankingResponseProcessor> {
    @Nonnull
    private final String campaignArn;
    @Nullable
    private final String description;
    @Nullable
    private final String iamRoleArn;
    @Nullable
    private final Boolean ignoreFailure;
    @Nullable
    private final String itemIdField;
    @Nonnull
    private final String recipe;
    @Nullable
    private final String tag;
    private final float weight;
    public static final JsonpDeserializer<PersonalizeSearchRankingResponseProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PersonalizeSearchRankingResponseProcessor::setupPersonalizeSearchRankingResponseProcessorDeserializer);

    private PersonalizeSearchRankingResponseProcessor(Builder builder) {
        this.campaignArn = ApiTypeHelper.requireNonNull(builder.campaignArn, this, "campaignArn");
        this.description = builder.description;
        this.iamRoleArn = builder.iamRoleArn;
        this.ignoreFailure = builder.ignoreFailure;
        this.itemIdField = builder.itemIdField;
        this.recipe = ApiTypeHelper.requireNonNull(builder.recipe, this, "recipe");
        this.tag = builder.tag;
        this.weight = ApiTypeHelper.requireNonNull(builder.weight, this, "weight").floatValue();
    }

    public static PersonalizeSearchRankingResponseProcessor of(Function<Builder, ObjectBuilder<PersonalizeSearchRankingResponseProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ResponseProcessor.Kind _responseProcessorKind() {
        return ResponseProcessor.Kind.PersonalizeSearchRanking;
    }

    @Nonnull
    public final String campaignArn() {
        return this.campaignArn;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    @Nullable
    public final Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    @Nullable
    public final String itemIdField() {
        return this.itemIdField;
    }

    @Nonnull
    public final String recipe() {
        return this.recipe;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    public final float weight() {
        return this.weight;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("campaign_arn");
        generator.write(this.campaignArn);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.iamRoleArn != null) {
            generator.writeKey("iam_role_arn");
            generator.write(this.iamRoleArn);
        }
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure.booleanValue());
        }
        if (this.itemIdField != null) {
            generator.writeKey("item_id_field");
            generator.write(this.itemIdField);
        }
        generator.writeKey("recipe");
        generator.write(this.recipe);
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
        generator.writeKey("weight");
        generator.write((double)this.weight);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPersonalizeSearchRankingResponseProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::campaignArn, JsonpDeserializer.stringDeserializer(), "campaign_arn");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::iamRoleArn, JsonpDeserializer.stringDeserializer(), "iam_role_arn");
        op.add(Builder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure");
        op.add(Builder::itemIdField, JsonpDeserializer.stringDeserializer(), "item_id_field");
        op.add(Builder::recipe, JsonpDeserializer.stringDeserializer(), "recipe");
        op.add(Builder::tag, JsonpDeserializer.stringDeserializer(), "tag");
        op.add(Builder::weight, JsonpDeserializer.floatDeserializer(), "weight");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.campaignArn.hashCode();
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.iamRoleArn);
        result = 31 * result + Objects.hashCode(this.ignoreFailure);
        result = 31 * result + Objects.hashCode(this.itemIdField);
        result = 31 * result + this.recipe.hashCode();
        result = 31 * result + Objects.hashCode(this.tag);
        result = 31 * result + Float.hashCode(this.weight);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonalizeSearchRankingResponseProcessor other = (PersonalizeSearchRankingResponseProcessor)o;
        return this.campaignArn.equals(other.campaignArn) && Objects.equals(this.description, other.description) && Objects.equals(this.iamRoleArn, other.iamRoleArn) && Objects.equals(this.ignoreFailure, other.ignoreFailure) && Objects.equals(this.itemIdField, other.itemIdField) && this.recipe.equals(other.recipe) && Objects.equals(this.tag, other.tag) && this.weight == other.weight;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, PersonalizeSearchRankingResponseProcessor> {
        private String campaignArn;
        @Nullable
        private String description;
        @Nullable
        private String iamRoleArn;
        @Nullable
        private Boolean ignoreFailure;
        @Nullable
        private String itemIdField;
        private String recipe;
        @Nullable
        private String tag;
        private Float weight;

        public Builder() {
        }

        private Builder(PersonalizeSearchRankingResponseProcessor o) {
            this.campaignArn = o.campaignArn;
            this.description = o.description;
            this.iamRoleArn = o.iamRoleArn;
            this.ignoreFailure = o.ignoreFailure;
            this.itemIdField = o.itemIdField;
            this.recipe = o.recipe;
            this.tag = o.tag;
            this.weight = Float.valueOf(o.weight);
        }

        private Builder(Builder o) {
            this.campaignArn = o.campaignArn;
            this.description = o.description;
            this.iamRoleArn = o.iamRoleArn;
            this.ignoreFailure = o.ignoreFailure;
            this.itemIdField = o.itemIdField;
            this.recipe = o.recipe;
            this.tag = o.tag;
            this.weight = o.weight;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder campaignArn(String value) {
            this.campaignArn = value;
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder iamRoleArn(@Nullable String value) {
            this.iamRoleArn = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return this;
        }

        @Nonnull
        public final Builder itemIdField(@Nullable String value) {
            this.itemIdField = value;
            return this;
        }

        @Nonnull
        public final Builder recipe(String value) {
            this.recipe = value;
            return this;
        }

        @Nonnull
        public final Builder tag(@Nullable String value) {
            this.tag = value;
            return this;
        }

        @Nonnull
        public final Builder weight(float value) {
            this.weight = Float.valueOf(value);
            return this;
        }

        @Override
        @Nonnull
        public PersonalizeSearchRankingResponseProcessor build() {
            this._checkSingleUse();
            return new PersonalizeSearchRankingResponseProcessor(this);
        }
    }
}

