/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.normalization.bounds;

import java.util.Map;
import org.opensearch.neuralsearch.processor.normalization.bounds.BoundMode;
import org.opensearch.neuralsearch.processor.normalization.bounds.ScoreBound;

public class LowerBound
extends ScoreBound {
    public static final float DEFAULT_LOWER_BOUND_SCORE = 0.0f;
    private static final String PARAM_NAME_LOWER_BOUND_MIN_SCORE = "min_score";

    public LowerBound() {
        this(false, BoundMode.DEFAULT, 0.0f);
    }

    public LowerBound(boolean enabled, BoundMode mode, float boundScore) {
        super(enabled, mode, boundScore);
    }

    public LowerBound(Map<String, Object> lowerBound) {
        this(true, LowerBound.parseBoundMode(lowerBound), LowerBound.parseBoundScore(lowerBound, PARAM_NAME_LOWER_BOUND_MIN_SCORE, 0.0f));
    }

    @Override
    public float determineEffectiveScore(float score, float minScore, float maxScore) {
        if (!this.enabled) {
            return minScore;
        }
        return switch (this.mode) {
            default -> throw new MatchException(null, null);
            case BoundMode.APPLY -> {
                if (maxScore > this.boundScore && score > this.boundScore) {
                    yield this.boundScore;
                }
                yield minScore;
            }
            case BoundMode.CLIP -> {
                if (maxScore < this.boundScore) {
                    yield minScore;
                }
                yield this.boundScore;
            }
            case BoundMode.IGNORE -> minScore;
        };
    }

    @Override
    public boolean shouldClipToBound(float score, float effectiveScore) {
        return this.enabled && this.mode == BoundMode.CLIP && score < effectiveScore;
    }
}

