/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@PublicApi(since="1.0.0")
public class NodesInfoRequest
extends BaseNodesRequest<NodesInfoRequest> {
    private Set<String> requestedMetrics = Metric.defaultMetrics();

    public NodesInfoRequest(StreamInput in) throws IOException {
        super(in);
        this.requestedMetrics.clear();
        this.requestedMetrics.addAll(Arrays.asList(in.readStringArray()));
    }

    public NodesInfoRequest(String ... nodesIds) {
        super(nodesIds);
        this.defaultMetrics();
    }

    public NodesInfoRequest clear() {
        this.requestedMetrics.clear();
        return this;
    }

    public NodesInfoRequest all() {
        this.requestedMetrics.addAll(Metric.allMetrics());
        return this;
    }

    public NodesInfoRequest defaultMetrics() {
        this.requestedMetrics.addAll(Metric.defaultMetrics());
        return this;
    }

    public Set<String> requestedMetrics() {
        return new HashSet<String>(this.requestedMetrics);
    }

    public NodesInfoRequest addMetric(String metric) {
        if (!Metric.allMetrics().contains(metric)) {
            throw new IllegalStateException("Used an illegal metric: " + metric);
        }
        this.requestedMetrics.add(metric);
        return this;
    }

    public NodesInfoRequest addMetrics(String ... metrics) {
        TreeSet<String> metricsSet = new TreeSet<String>(Arrays.asList(metrics));
        if (!Metric.allMetrics().containsAll(metricsSet)) {
            metricsSet.removeAll(Metric.allMetrics());
            String plural = metricsSet.size() == 1 ? "" : "s";
            throw new IllegalStateException("Used illegal metric" + plural + ": " + String.valueOf(metricsSet));
        }
        this.requestedMetrics.addAll(metricsSet);
        return this;
    }

    public NodesInfoRequest removeMetric(String metric) {
        if (!Metric.allMetrics().contains(metric)) {
            throw new IllegalStateException("Used an illegal metric: " + metric);
        }
        this.requestedMetrics.remove(metric);
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.requestedMetrics.toArray(new String[0]));
    }

    public static enum Metric {
        SETTINGS("settings"),
        OS("os"),
        PROCESS("process"),
        JVM("jvm"),
        THREAD_POOL("thread_pool"),
        TRANSPORT("transport"),
        HTTP("http"),
        PLUGINS("plugins"),
        INGEST("ingest"),
        AGGREGATIONS("aggregations"),
        INDICES("indices"),
        SEARCH_PIPELINES("search_pipelines");

        private String metricName;

        private Metric(String name) {
            this.metricName = name;
        }

        public String metricName() {
            return this.metricName;
        }

        boolean containedIn(Set<String> metricNames) {
            return metricNames.contains(this.metricName());
        }

        public static Set<String> allMetrics() {
            return Arrays.stream(Metric.values()).map(Metric::metricName).collect(Collectors.toSet());
        }

        public static Set<String> defaultMetrics() {
            return Metric.allMetrics().stream().filter(metric -> !metric.equals(SEARCH_PIPELINES.metricName())).collect(Collectors.toSet());
        }
    }
}

