/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public final class RepositoryInfo
implements Writeable,
ToXContentFragment {
    public final String name;
    public final String type;
    public final Map<String, String> location;

    public RepositoryInfo(String name, String type, Map<String, String> location) {
        this.name = name;
        this.type = type;
        this.location = location;
    }

    public RepositoryInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.location = in.readMap(StreamInput::readString, StreamInput::readString);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeMap(this.location, StreamOutput::writeString, StreamOutput::writeString);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("repository_name", this.name);
        builder.field("repository_type", this.type);
        builder.field("repository_location", this.location);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryInfo that = (RepositoryInfo)o;
        return this.name.equals(that.name) && this.type.equals(that.type) && this.location.equals(that.location);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.location);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }
}

