/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.XSNamespaceI;
import oracle.jdbc.driver.XSSecureIdI;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.internal.XSSecureId;

class T4CTTIoxsns
extends T4CTTIfun {
    private OracleConnection.XSOperationCode operationCode;
    private byte[] sessionId;
    private XSNamespace[] namespaces;
    private XSSecureId secureId;
    private XSNamespace[] outNamespaces;

    T4CTTIoxsns(T4CConnection _conn) {
        super(_conn, (byte)3);
        this.setFunCode((short)178);
    }

    void doOXSNS(OracleConnection.XSOperationCode _operationCode, byte[] _sessionId, XSNamespace[] _namespaces, XSSecureId secureId, boolean roundTripRPC) throws IOException, SQLException {
        if (roundTripRPC) {
            this.setTTCCode((byte)3);
        } else {
            this.setTTCCode((byte)17);
        }
        this.operationCode = _operationCode;
        this.sessionId = _sessionId;
        this.namespaces = _namespaces;
        this.secureId = secureId;
        if (this.namespaces != null) {
            for (int i = 0; i < this.namespaces.length; ++i) {
                ((XSNamespaceI)this.namespaces[i]).doCharConversion(this.meg.conv);
            }
        }
        if (roundTripRPC) {
            this.doRPC();
        } else {
            this.doPigRPC();
        }
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalUB4(this.operationCode.getCode());
        boolean sendSessionId = false;
        if (this.sessionId != null && this.sessionId.length > 0) {
            sendSessionId = true;
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.sessionId.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        boolean sendNamespaces = false;
        this.meg.marshalPTR();
        if (this.namespaces != null && this.namespaces.length > 0) {
            sendNamespaces = true;
            this.meg.marshalUB4(this.namespaces.length);
        } else {
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalPTR();
        if (this.secureId == null) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        if (sendSessionId) {
            this.meg.marshalB1Array(this.sessionId);
        }
        if (sendNamespaces) {
            for (int i = 0; i < this.namespaces.length; ++i) {
                ((XSNamespaceI)this.namespaces[i]).marshal(this.meg);
            }
        }
        if (this.secureId != null) {
            ((XSSecureIdI)this.secureId).marshal(this.meg);
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        this.outNamespaces = null;
        int namespacesLength = (int)this.meg.unmarshalUB4();
        if (namespacesLength > 0) {
            this.outNamespaces = new XSNamespace[namespacesLength];
            for (int i = 0; i < namespacesLength; ++i) {
                this.outNamespaces[i] = XSNamespaceI.unmarshal(this.meg);
            }
        }
    }

    XSNamespace[] getNamespaces() throws SQLException {
        return this.outNamespaces;
    }
}

