/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.cdi;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.opentelemetry.instrumentation.api.annotation.support.MethodSpanAttributesExtractor;
import io.opentelemetry.instrumentation.api.annotation.support.ParameterAttributeNamesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.util.SpanNames;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.semconv.incubating.CodeIncubatingAttributes;
import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.tracing.cdi.MethodRequest;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.tuples.Functions;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;

@Interceptor
@Priority(value=0)
public class WithSpanInterceptor {
    private final Instrumenter<MethodRequest, Void> instrumenter;

    public WithSpanInterceptor(OpenTelemetry openTelemetry, OTelRuntimeConfig runtimeConfig) {
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)new MethodRequestSpanNameExtractor());
        builder.setEnabled(!runtimeConfig.sdkDisabled());
        MethodSpanAttributesExtractor attributesExtractor = MethodSpanAttributesExtractor.create(MethodRequest::getMethod, (ParameterAttributeNamesExtractor)new WithSpanParameterAttributeNamesExtractor(), MethodRequest::getArgs);
        this.instrumenter = builder.addAttributesExtractor((AttributesExtractor)ClassMethodNameAttributesExtractor.INSTANCE).addAttributesExtractor((AttributesExtractor)attributesExtractor).buildInstrumenter((SpanKindExtractor)new SpanKindExtractor<MethodRequest>(){

            public SpanKind extract(MethodRequest methodRequest) {
                return WithSpanInterceptor.spanKindFromMethod(methodRequest.getAnnotationBindings());
            }
        });
    }

    @AroundInvoke
    public Object span(ArcInvocationContext invocationContext) throws Exception {
        final MethodRequest methodRequest = new MethodRequest(invocationContext.getMethod(), invocationContext.getParameters(), invocationContext.getInterceptorBindings());
        Class<?> returnType = invocationContext.getMethod().getReturnType();
        Context parentContext = Context.current();
        boolean shouldStart = this.instrumenter.shouldStart(parentContext, (Object)methodRequest);
        if (!shouldStart) {
            return invocationContext.proceed();
        }
        if (WithSpanInterceptor.isUni(returnType)) {
            final Context currentSpanContext = this.instrumenter.start(parentContext, (Object)methodRequest);
            final Scope currentScope = currentSpanContext.makeCurrent();
            return ((Uni)invocationContext.proceed()).onTermination().invoke((Functions.TriConsumer)new Functions.TriConsumer<Object, Throwable, Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void accept(Object o, Throwable throwable, Boolean isCancelled) {
                    try {
                        if (isCancelled.booleanValue()) {
                            WithSpanInterceptor.this.instrumenter.end(currentSpanContext, (Object)methodRequest, null, (Throwable)new CancellationException());
                        } else if (throwable != null) {
                            WithSpanInterceptor.this.instrumenter.end(currentSpanContext, (Object)methodRequest, null, throwable);
                        } else {
                            WithSpanInterceptor.this.instrumenter.end(currentSpanContext, (Object)methodRequest, null, null);
                        }
                    }
                    finally {
                        if (currentScope != null) {
                            currentScope.close();
                        }
                    }
                }
            });
        }
        if (WithSpanInterceptor.isMulti(returnType)) {
            final Context currentSpanContext = this.instrumenter.start(parentContext, (Object)methodRequest);
            final Scope currentScope = currentSpanContext.makeCurrent();
            return ((Multi)invocationContext.proceed()).onTermination().invoke((BiConsumer)new BiConsumer<Throwable, Boolean>(){

                @Override
                public void accept(Throwable throwable, Boolean isCancelled) {
                    try {
                        if (isCancelled.booleanValue()) {
                            WithSpanInterceptor.this.instrumenter.end(currentSpanContext, (Object)methodRequest, null, (Throwable)new CancellationException());
                        } else if (throwable != null) {
                            WithSpanInterceptor.this.instrumenter.end(currentSpanContext, (Object)methodRequest, null, throwable);
                        } else {
                            WithSpanInterceptor.this.instrumenter.end(currentSpanContext, (Object)methodRequest, null, null);
                        }
                    }
                    finally {
                        if (currentScope != null) {
                            currentScope.close();
                        }
                    }
                }
            });
        }
        if (WithSpanInterceptor.isCompletionStage(returnType)) {
            final Context currentSpanContext = this.instrumenter.start(parentContext, (Object)methodRequest);
            final Scope currentScope = currentSpanContext.makeCurrent();
            return ((CompletionStage)invocationContext.proceed()).whenComplete(new BiConsumer<Object, Throwable>(){

                @Override
                public void accept(Object o, Throwable throwable) {
                    try {
                        if (throwable != null) {
                            WithSpanInterceptor.this.instrumenter.end(currentSpanContext, (Object)methodRequest, null, throwable);
                        } else {
                            WithSpanInterceptor.this.instrumenter.end(currentSpanContext, (Object)methodRequest, null, null);
                        }
                    }
                    finally {
                        if (currentScope != null) {
                            currentScope.close();
                        }
                    }
                }
            });
        }
        Context currentSpanContext = this.instrumenter.start(parentContext, (Object)methodRequest);
        try (Scope currentScope = currentSpanContext.makeCurrent();){
            Object result = invocationContext.proceed();
            this.instrumenter.end(currentSpanContext, (Object)methodRequest, null, null);
            Object object = result;
            return object;
        }
    }

    private static boolean isUni(Class<?> clazz) {
        return Uni.class.isAssignableFrom(clazz);
    }

    private static boolean isMulti(Class<?> clazz) {
        return Multi.class.isAssignableFrom(clazz);
    }

    private static boolean isCompletionStage(Class<?> clazz) {
        return CompletionStage.class.isAssignableFrom(clazz);
    }

    private static SpanKind spanKindFromMethod(Set<Annotation> annotations) {
        SpanKind spanKind = null;
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof WithSpan)) continue;
            spanKind = ((WithSpan)annotation).kind();
            break;
        }
        if (spanKind == null) {
            return SpanKind.INTERNAL;
        }
        return spanKind;
    }

    private static final class MethodRequestSpanNameExtractor
    implements SpanNameExtractor<MethodRequest> {
        private MethodRequestSpanNameExtractor() {
        }

        public String extract(MethodRequest methodRequest) {
            String spanName = null;
            for (Annotation annotation : methodRequest.getAnnotationBindings()) {
                if (!(annotation instanceof WithSpan)) continue;
                spanName = ((WithSpan)annotation).value();
                break;
            }
            if (spanName.isEmpty()) {
                spanName = SpanNames.fromMethod((Method)methodRequest.getMethod());
            }
            return spanName;
        }
    }

    private static final class WithSpanParameterAttributeNamesExtractor
    implements ParameterAttributeNamesExtractor {
        private WithSpanParameterAttributeNamesExtractor() {
        }

        public String[] extract(Method method, Parameter[] parameters) {
            String[] attributeNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                attributeNames[i] = WithSpanParameterAttributeNamesExtractor.attributeName(parameters[i]);
            }
            return attributeNames;
        }

        private static String attributeName(Parameter parameter) {
            String value = null;
            SpanAttribute spanAttribute = parameter.getDeclaredAnnotation(SpanAttribute.class);
            if (spanAttribute == null) {
                return null;
            }
            value = spanAttribute.value();
            if (!value.isEmpty()) {
                return value;
            }
            if (parameter.isNamePresent()) {
                return parameter.getName();
            }
            return null;
        }
    }

    private static final class ClassMethodNameAttributesExtractor
    implements AttributesExtractor<MethodRequest, Void> {
        private static final ClassMethodNameAttributesExtractor INSTANCE = new ClassMethodNameAttributesExtractor();

        private ClassMethodNameAttributesExtractor() {
        }

        public void onStart(AttributesBuilder attributesBuilder, Context context, MethodRequest methodRequest) {
            attributesBuilder.put(CodeIncubatingAttributes.CODE_NAMESPACE, (Object)methodRequest.getMethod().getDeclaringClass().getName());
            attributesBuilder.put(CodeIncubatingAttributes.CODE_FUNCTION, (Object)methodRequest.getMethod().getName());
        }

        public void onEnd(AttributesBuilder attributesBuilder, Context context, MethodRequest methodRequest, Void unused, Throwable throwable) {
        }
    }
}

