/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.hibernate.Incubating;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

@Incubating
public class SqmNamedExpression<T>
extends AbstractSqmExpression<T> {
    private final SqmExpression<T> expression;
    private final String name;

    public SqmNamedExpression(SqmExpression<T> expression, String name) {
        super(expression.getExpressible(), expression.nodeBuilder());
        this.expression = expression;
        this.name = name;
    }

    @Override
    public SqmNamedExpression<T> copy(SqmCopyContext context) {
        SqmNamedExpression existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmNamedExpression<T> expression = context.registerCopy(this, new SqmNamedExpression<T>(this.expression.copy(context), this.name));
        this.copyTo(expression, context);
        return expression;
    }

    public SqmExpression<T> getExpression() {
        return this.expression;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitNamedExpression(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.expression.appendHqlString(hql, context);
        hql.append(" as ");
        hql.append(this.name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmNamedExpression)) return false;
        SqmNamedExpression that = (SqmNamedExpression)object;
        if (!Objects.equals(this.name, that.name)) return false;
        if (!Objects.equals(this.expression, that.expression)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.name);
    }
}

