/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.jaxrs;

import io.quarkus.hibernate.validator.runtime.jaxrs.ValidatorMediaTypeUtil;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.jboss.resteasy.api.validation.ViolationReport;

@Provider
public class ResteasyViolationExceptionMapper
implements ExceptionMapper<ValidationException> {
    @Context
    HttpHeaders headers;

    public Response toResponse(ValidationException exception) {
        if (!(exception instanceof ResteasyViolationException)) {
            throw exception;
        }
        ResteasyViolationException restEasyException = (ResteasyViolationException)exception;
        Exception e = restEasyException.getException();
        if (e != null | restEasyException.getReturnValueViolations().size() != 0) {
            throw restEasyException;
        }
        return this.buildViolationReportResponse(restEasyException);
    }

    protected Response buildViolationReportResponse(ResteasyViolationException exception) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        builder.header("validation-exception", (Object)"true");
        MediaType mediaType = ValidatorMediaTypeUtil.getAcceptMediaType(this.headers.getAcceptableMediaTypes(), exception.getAccept());
        if (mediaType == null) {
            mediaType = MediaType.TEXT_PLAIN_TYPE;
        }
        if (MediaType.TEXT_PLAIN_TYPE.equals((Object)mediaType)) {
            builder.entity((Object)exception.toString());
        } else {
            builder.entity((Object)new ViolationReport(exception));
        }
        builder.type(mediaType);
        return builder.build();
    }
}

