/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.support;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gradle/kotlin/dsl/support/LoggingOutputStream;", "Ljava/io/OutputStream;", "log", "Lkotlin/Function1;", "", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getLog", "()Lkotlin/jvm/functions/Function1;", "buffer", "Ljava/io/ByteArrayOutputStream;", "write", "b", "", "", "off", "len", "flush", "close", "kotlin-dsl"})
final class LoggingOutputStream
extends OutputStream {
    @NotNull
    private final Function1<String, Unit> log;
    @NotNull
    private final ByteArrayOutputStream buffer;

    public LoggingOutputStream(@NotNull Function1<? super String, Unit> log) {
        Intrinsics.checkNotNullParameter(log, (String)"log");
        this.log = log;
        this.buffer = new ByteArrayOutputStream();
    }

    @NotNull
    public final Function1<String, Unit> getLog() {
        return this.log;
    }

    @Override
    public void write(int b) {
        this.buffer.write(b);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.buffer.write(b, off, len);
    }

    @Override
    public void flush() {
        ByteArrayOutputStream $this$flush_u24lambda_u240 = this.buffer;
        boolean bl = false;
        String string = $this$flush_u24lambda_u240.toString("utf8");
        Intrinsics.checkNotNull((Object)string);
        if (!StringsKt.isBlank((CharSequence)string)) {
            this.log.invoke((Object)string);
        }
        $this$flush_u24lambda_u240.reset();
    }

    @Override
    public void close() {
        this.flush();
    }
}

