/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.edit;

import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.StyleNameMappingHelper;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.plugin.ai.tools.edit.EditOperation;

public class NodeStyleContentEditor {
    public void setInitialMainStyle(NodeModel nodeModel, String mainStyle) {
        if (nodeModel == null || mainStyle == null) {
            return;
        }
        this.setMainStyle(nodeModel, mainStyle);
    }

    public void editMainStyle(NodeModel nodeModel, EditOperation operation, String styleName) {
        if (nodeModel == null) {
            throw new IllegalArgumentException("Missing node model.");
        }
        if (operation == null) {
            throw new IllegalArgumentException("Missing edit operation.");
        }
        switch (operation) {
            case REPLACE: {
                if (styleName == null || styleName.trim().isEmpty()) {
                    throw new IllegalArgumentException("Missing style name.");
                }
                this.setMainStyle(nodeModel, styleName);
                return;
            }
            case DELETE: {
                this.clearMainStyle(nodeModel);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported style edit operation: " + String.valueOf((Object)operation));
    }

    private void setMainStyle(NodeModel nodeModel, String styleName) {
        IStyle style = StyleNameMappingHelper.findStyleByNameOrThrow((MapModel)nodeModel.getMap(), (String)styleName);
        this.getStyleController().setStyle(nodeModel, style);
    }

    private void clearMainStyle(NodeModel nodeModel) {
        this.getStyleController().setStyle(nodeModel, null);
    }

    private MLogicalStyleController getStyleController() {
        return (MLogicalStyleController)LogicalStyleController.getController();
    }
}

