/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.chunker.DefaultChunkerContextGenerator;
import opennlp.tools.chunker.DefaultChunkerSequenceValidator;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.TokenTag;
import opennlp.tools.util.ext.ExtensionLoader;

public class ChunkerFactory
extends BaseToolFactory {
    public static ChunkerFactory create(String subclassName) throws InvalidFormatException {
        if (subclassName == null) {
            return new ChunkerFactory();
        }
        try {
            return ExtensionLoader.instantiateExtension(ChunkerFactory.class, subclassName);
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization threw an exception.";
            throw new InvalidFormatException(msg, e);
        }
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
    }

    public SequenceValidator<TokenTag> getSequenceValidator() {
        return new DefaultChunkerSequenceValidator();
    }

    public ChunkerContextGenerator getContextGenerator() {
        return new DefaultChunkerContextGenerator();
    }
}

