/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.security.AllPermission;
import org.knopflerfish.framework.permissions.PermissionInfoStorage;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public class PermissionAdminImpl
implements PermissionAdmin {
    public static final String SPEC_VERSION = "1.2";
    private final AllPermission ALL_PERMISSION = new AllPermission();
    private final PermissionInfoStorage pinfos;

    public PermissionAdminImpl(PermissionInfoStorage pis) {
        this.pinfos = pis;
    }

    @Override
    public PermissionInfo[] getPermissions(String location) {
        PermissionInfo[] res = this.pinfos.get(location, null);
        return res != null ? (PermissionInfo[])res.clone() : null;
    }

    @Override
    public synchronized void setPermissions(String location, PermissionInfo[] perms) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.ALL_PERMISSION);
        }
        if (perms != null) {
            this.pinfos.put(location, (PermissionInfo[])perms.clone());
        } else {
            this.pinfos.remove(location);
        }
    }

    @Override
    public String[] getLocations() {
        return this.pinfos.getKeys();
    }

    @Override
    public synchronized PermissionInfo[] getDefaultPermissions() {
        PermissionInfo[] res = this.pinfos.getDefault(null);
        return res != null ? (PermissionInfo[])res.clone() : null;
    }

    @Override
    public synchronized void setDefaultPermissions(PermissionInfo[] perms) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.ALL_PERMISSION);
        }
        if (perms != null) {
            perms = (PermissionInfo[])perms.clone();
        }
        this.pinfos.putDefault(perms);
    }
}

