/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.AltibaseConstants;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseMetaModel;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;

public class AltibasePackage
extends GenericPackage
implements DBPStatefulObject {
    protected String schemaName;
    private String source;
    private boolean valid;
    private boolean hasBody;

    public AltibasePackage(GenericStructContainer container, String packageName, JDBCResultSet dbResult) {
        super(container, packageName, true);
        this.schemaName = container.getName();
        this.valid = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"STATUS", (String)"0");
    }

    public void setBody(boolean hasBody) {
        this.hasBody = hasBody;
    }

    public void setStatus(boolean valid) {
        this.valid = this.valid && valid;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.source == null) {
            this.source = "-- Package specification " + AltibaseConstants.NEW_LINE + ((AltibaseMetaModel)this.getDataSource().getMetaModel()).getPackageDDL(monitor, this, 6) + AltibaseConstants.NEW_LINE + "-- Package body " + AltibaseConstants.NEW_LINE;
            this.source = this.hasBody ? this.source + ((AltibaseMetaModel)this.getDataSource().getMetaModel()).getPackageDDL(monitor, this, 7) : this.source + "-- No body definition";
        }
        return this.source;
    }

    @Property(viewable=true, order=5)
    public boolean isValid() {
        return this.valid;
    }

    @Property(viewable=false, hidden=true, order=3, labelProvider=GenericCatalog.CatalogNameTermProvider.class)
    public GenericCatalog getCatalog() {
        return super.getCatalog();
    }

    public void refreshState(JDBCSession session) throws DBCException {
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT status FROM system_.sys_users_ u, system_.sys_packages_ p WHERE p.package_type = 7 AND u.user_id = p.user_id AND u.user_name = ? AND package_name = ?");){
            dbStat.setString(1, this.schemaName);
            dbStat.setString(2, this.getName());
            dbStat.executeStatement();
            try (JDBCResultSet dbResult = dbStat.getResultSet();){
                if (dbResult != null && dbResult.next()) {
                    this.valid = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (int)1, (String)"0");
                }
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Refresh state of package '" + this.getName() + "'"));){
            this.refreshState(session);
        }
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Refresh state of package '" + this.getName() + "'"));){
            this.refreshState(session);
        }
        return this;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.valid ? DBSObjectState.NORMAL : DBSObjectState.INVALID;
    }
}

