/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.AlphanumericComparator;
import org.jkiss.utils.ArrayUtils;

public class ResourceUtils {
    private static final Log log = Log.getLog(ResourceUtils.class);

    public static void checkFolderExists(IFolder folder) throws DBException {
        ResourceUtils.checkFolderExists(folder, (DBRProgressMonitor)new VoidProgressMonitor());
    }

    public static void checkFolderExists(IFolder folder, DBRProgressMonitor monitor) throws DBException {
        if (!folder.exists()) {
            try {
                folder.create(true, true, monitor.getNestedMonitor());
            }
            catch (CoreException e) {
                throw new DBException("Can't create folder '" + String.valueOf(folder.getFullPath()) + "'", (Throwable)e);
            }
        }
    }

    public static long getResourceLastModified(IResource resource) {
        try {
            IFileStore fileStore = EFS.getStore((URI)resource.getLocationURI());
            IFileInfo iFileInfo = fileStore.fetchInfo();
            return iFileInfo.getLastModified();
        }
        catch (CoreException e) {
            log.debug((Object)e);
            return -1L;
        }
    }

    public static long getFileLength(IResource resource) {
        try {
            IFileStore fileStore = EFS.getStore((URI)resource.getLocationURI());
            IFileInfo iFileInfo = fileStore.fetchInfo();
            return iFileInfo.getLength();
        }
        catch (CoreException e) {
            log.debug((Object)e);
            return -1L;
        }
    }

    public static void syncFile(DBRProgressMonitor monitor, IResource localFile) {
        try {
            localFile.refreshLocal(0, monitor.getNestedMonitor());
        }
        catch (CoreException e) {
            log.warn((Object)("Can't synchronize file '" + String.valueOf(localFile) + "' with contents"), (Throwable)e);
        }
    }

    @NotNull
    public static IFile getUniqueFile(@NotNull IFolder folder, @NotNull String fileName, @NotNull String fileExt) {
        Matcher matcher;
        IResource[] members;
        IFile file = folder.getFile(fileName + "." + fileExt);
        if (!file.exists()) {
            return file;
        }
        try {
            members = folder.members();
        }
        catch (CoreException ignored) {
            return ResourceUtils.getUniqueFileFallback(folder, fileName, fileExt);
        }
        Pattern pattern = Pattern.compile("^%s-(\\d+).%s".formatted(Pattern.quote(fileName), Pattern.quote(fileExt)));
        List<IResource> files = Stream.of(members).filter(r -> pattern.matcher(r.getName()).matches()).sorted(Comparator.comparing(IResource::getName, AlphanumericComparator.getInstance())).toList();
        if (!files.isEmpty() && (matcher = pattern.matcher(files.getLast().getName())).matches()) {
            try {
                int index = Integer.parseInt(matcher.group(1));
                return folder.getFile(fileName + "-" + (index + 1) + "." + fileExt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ResourceUtils.getUniqueFileFallback(folder, fileName, fileExt);
    }

    @NotNull
    private static IFile getUniqueFileFallback(@NotNull IFolder folder, @NotNull String fileName, @NotNull String fileExt) {
        IFile file = folder.getFile(fileName + "." + fileExt);
        int index = 1;
        while (file.exists()) {
            file = folder.getFile(fileName + "-" + index + "." + fileExt);
            ++index;
        }
        return file;
    }

    @Nullable
    public static IFile convertPathToWorkspaceFile(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation(path);
        if (file != null) {
            return file;
        }
        IPath folderPath = path.removeLastSegments(1);
        URI folderURI = folderPath.toFile().toURI();
        Object[] containers = root.findContainersForLocationURI(folderURI);
        if (!ArrayUtils.isEmpty((Object[])containers)) {
            Object container = containers[0];
            file = container.getFile(path.removeFirstSegments(path.segmentCount() - 1));
        }
        return file;
    }

    @Nullable
    public static IPath convertPathToWorkspacePath(IPath path) {
        IFile wFile = ResourceUtils.convertPathToWorkspaceFile(path);
        return wFile == null ? null : wFile.getFullPath();
    }

    public static void deleteTempFile(DBRProgressMonitor monitor, IFile file) {
        try {
            file.delete(true, false, monitor.getNestedMonitor());
        }
        catch (CoreException e) {
            log.warn((Object)("Can't delete temporary file '" + file.getFullPath().toString() + "'"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToFile(DBRProgressMonitor monitor, InputStream inputStream, long contentLength, IFile localFile) throws IOException {
        File file = localFile.getLocation().toFile();
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            ContentUtils.copyStreams((InputStream)inputStream, (long)contentLength, (OutputStream)outputStream, (DBRProgressMonitor)monitor);
        }
        finally {
            inputStream.close();
        }
        ResourceUtils.syncFile(monitor, (IResource)localFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyReaderToFile(DBRProgressMonitor monitor, Reader reader, long contentLength, String charset, IFile localFile) throws IOException {
        try {
            if (charset == null) {
                charset = localFile.getCharset();
            } else {
                localFile.setCharset(charset, monitor.getNestedMonitor());
            }
        }
        catch (CoreException e) {
            log.warn((Object)"Can't set content charset", (Throwable)e);
        }
        File file = localFile.getLocation().toFile();
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, charset == null ? GeneralUtils.DEFAULT_ENCODING : charset);
            ContentUtils.copyStreams((Reader)reader, (long)contentLength, (Writer)writer, (DBRProgressMonitor)monitor);
            ((Writer)writer).flush();
        }
        finally {
            reader.close();
        }
        ResourceUtils.syncFile(monitor, (IResource)localFile);
    }
}

