/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageMeta;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIClient;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIRequestFilter;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIMessage;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesRequest;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesResponse;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.legacy.ChatCompletionRequest;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.legacy.ChatCompletionResult;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.legacy.ChatMessage;
import org.jkiss.dbeaver.model.ai.utils.AIHttpUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OpenAIClientLegacy
extends OpenAIClient {
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);
    private static final Gson GSON = new GsonBuilder().create();

    public OpenAIClientLegacy(@NotNull String baseUrl, @NotNull List<OpenAIClient.HttpRequestFilter> requestFilters) {
        super(baseUrl, requestFilters);
    }

    @NotNull
    public static OpenAIClientLegacy createClient(@NotNull String baseUrl, @NotNull String token) {
        return new OpenAIClientLegacy(baseUrl, List.of(new OpenAIRequestFilter(token)));
    }

    @Override
    @NotNull
    public OAIResponsesResponse createChatCompletion(@NotNull DBRProgressMonitor monitor, @NotNull OAIResponsesRequest completionRequest) throws DBException {
        Instant now = Instant.now();
        ChatCompletionRequest chatRequest = new ChatCompletionRequest();
        chatRequest.setMessages(completionRequest.input.stream().map(om -> new ChatMessage(om.role, om.content.getFirst().text, om.name)).toList());
        chatRequest.setModel(completionRequest.model);
        if (completionRequest.temperature != null) {
            chatRequest.setTemperature(completionRequest.temperature);
        }
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(this.baseUrl, "chat/completions")).POST(HttpRequest.BodyPublishers.ofString(OpenAIClientLegacy.serializeValue(chatRequest))).timeout(TIMEOUT).build();
        HttpRequest modifiedRequest = this.applyFilters(request);
        String response = this.client.send(monitor, modifiedRequest);
        ChatCompletionResult chatCompletionResult = (ChatCompletionResult)GSON.fromJson(response, ChatCompletionResult.class);
        int systemPromptLength = completionRequest.input.stream().filter(it -> it.role.toLowerCase(Locale.ROOT).equals("system")).mapToInt(it -> it.content.getFirst().text.length()).sum();
        AIMessageMeta messageMeta = new AIMessageMeta("openai", completionRequest.model, chatCompletionResult.getAIUsage(), Duration.between(now, Instant.now()), systemPromptLength);
        OAIResponsesResponse oaiResponse = new OAIResponsesResponse();
        oaiResponse.output = chatCompletionResult.getChoices().stream().map(c -> new OAIMessage(new AIMessage(AIMessageType.ASSISTANT, c.getMessage().getContent(), messageMeta))).toList();
        return oaiResponse;
    }
}

