﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/budgets/Budgets_EXPORTS.h>
#include <aws/budgets/model/ExecutionType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Budgets {
namespace Model {
class ExecuteBudgetActionResult {
 public:
  AWS_BUDGETS_API ExecuteBudgetActionResult() = default;
  AWS_BUDGETS_API ExecuteBudgetActionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BUDGETS_API ExecuteBudgetActionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const Aws::String& GetAccountId() const { return m_accountId; }
  template <typename AccountIdT = Aws::String>
  void SetAccountId(AccountIdT&& value) {
    m_accountIdHasBeenSet = true;
    m_accountId = std::forward<AccountIdT>(value);
  }
  template <typename AccountIdT = Aws::String>
  ExecuteBudgetActionResult& WithAccountId(AccountIdT&& value) {
    SetAccountId(std::forward<AccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetBudgetName() const { return m_budgetName; }
  template <typename BudgetNameT = Aws::String>
  void SetBudgetName(BudgetNameT&& value) {
    m_budgetNameHasBeenSet = true;
    m_budgetName = std::forward<BudgetNameT>(value);
  }
  template <typename BudgetNameT = Aws::String>
  ExecuteBudgetActionResult& WithBudgetName(BudgetNameT&& value) {
    SetBudgetName(std::forward<BudgetNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> A system-generated universally unique identifier (UUID) for the action. </p>
   */
  inline const Aws::String& GetActionId() const { return m_actionId; }
  template <typename ActionIdT = Aws::String>
  void SetActionId(ActionIdT&& value) {
    m_actionIdHasBeenSet = true;
    m_actionId = std::forward<ActionIdT>(value);
  }
  template <typename ActionIdT = Aws::String>
  ExecuteBudgetActionResult& WithActionId(ActionIdT&& value) {
    SetActionId(std::forward<ActionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The type of execution. </p>
   */
  inline ExecutionType GetExecutionType() const { return m_executionType; }
  inline void SetExecutionType(ExecutionType value) {
    m_executionTypeHasBeenSet = true;
    m_executionType = value;
  }
  inline ExecuteBudgetActionResult& WithExecutionType(ExecutionType value) {
    SetExecutionType(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ExecuteBudgetActionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_accountId;

  Aws::String m_budgetName;

  Aws::String m_actionId;

  ExecutionType m_executionType{ExecutionType::NOT_SET};

  Aws::String m_requestId;
  bool m_accountIdHasBeenSet = false;
  bool m_budgetNameHasBeenSet = false;
  bool m_actionIdHasBeenSet = false;
  bool m_executionTypeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Budgets
}  // namespace Aws
