/*
 * Distributed under the OSI-approved Apache License, Version 2.0.  See
 * accompanying file Copyright.txt for details.
 *
 * adios2.h : single unique header for applications using ADIOS2 C++11 bindings
 *
 *  Created on: Jun 4, 2018
 *      Author: William F Godoy godoywf@ornl.gov
 */

#ifndef ADIOS2_BINDINGS_CXX_H_
#define ADIOS2_BINDINGS_CXX_H_

#include "adios2/common/ADIOSConfig.h"
#include "adios2/common/ADIOSMacros.h"
#include "adios2/common/ADIOSTypes.h"

#include "adios2/cxx/ADIOS.h"
#include "adios2/cxx/Attribute.h"
#include "adios2/cxx/Engine.h"
#include "adios2/cxx/Group.h"
#include "adios2/cxx/IO.h"
#include "adios2/cxx/Operator.h"
#include "adios2/cxx/Query.h"
#include "adios2/cxx/Types.h"
#include "adios2/cxx/Variable.h"
#include "adios2/cxx/fstream/ADIOS2fstream.h"

#endif /* ADIOS2_BINDINGS_CXX_H_ */
