/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main.h"

#include <qpushbutton.h>
#include <qfiledialog.h>
#include <qpainter.h>
#include <qpen.h>
#include <qtimer.h>
#include <qmessagebox.h>
#include <qpixmap.h>

#include <kapp.h>
#include <kconfig.h>
#include <kmessagebox.h>

#include "kpuzzle.h"
#include "kpuzzleview.h"
#include "gamewidget.h"
#include "kpuzzleapp.h"
#include "piecewidget.h"
#include "picview.h"

#include "gamedialog.h"
#include "highscore.h"

KPuzzleView::KPuzzleView(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	setFixedSize(800,600);
	//setBackgroundMode(PaletteDark);
	//setBackgroundMode(FixedPixmap);
	_backgroundPxm = new QPixmap(PICFILE("gamebg.bmp"));
	_game = NULL;
        _largePxm = NULL;

	_logoPxm = NULL;
	_bigLogoPxm = NULL;
	_winPxm = NULL;
	_losePxm = NULL;
	_pausePxm = NULL;
	_backgroundPxm = NULL;

	_usedGamePixmaps = 0;

	if (kapp->sessionConfig()->readNumEntry("ImageLoading",SV_IMAGE_LOADING) == IL_PRELOAD)
		QTimer::singleShot(0,this,SLOT(slotLoadBackgroundPixmap()));
	useGamePixmap(GP_BIGLOGO);
}

KPuzzleView::~KPuzzleView()
{
	if (_logoPxm) delete _logoPxm;
	if (_bigLogoPxm) delete _bigLogoPxm;
	if (_winPxm) delete _winPxm;
	if (_losePxm) delete _losePxm;
	if (_pausePxm) delete _pausePxm;
	delete _game;
	delete _backgroundPxm;
}

int KPuzzleView::status()
{
	if (!game()) return GS_NOT_STARTED;
        return game()->status();
}

void KPuzzleView::updateAll()
{
	_gameWidget->update(); _pieceWidget->update();
}

void KPuzzleView::useGamePixmap(int which)
{
	//QString xxxx(PICFILE("biglogo.bmp"));
        if (which & _usedGamePixmaps) return; // already loaded
	switch(which) {
	case GP_BIGLOGO: _bigLogoPxm = new QPixmap(PICFILE("biglogo.bmp")); break;
	case GP_PAUSE: _pausePxm = new QPixmap(PICFILE("pause.bmp")); break;
	case GP_WIN: _winPxm = new QPixmap(PICFILE("win.bmp")); break;
	case GP_LOSE: _losePxm = new QPixmap(PICFILE("lose.bmp")); break;
	case GP_LOGO: _logoPxm = new QPixmap(PICFILE("logo.bmp")); break;
	case GP_BACKGROUND: _backgroundPxm = new QPixmap(PICFILE("background.bmp")); break;
	default: fatal("Terrible error in KPuzzleView::useGamePixmap");
	}
	_usedGamePixmaps |= which;
	//	debug("biglogo= %s",(const char*) xxxx);
//        ASSERT(!_bigLogoPxm->isNull());
}

void KPuzzleView::freeGamePixmap(int which)
{
	if (kapp->sessionConfig()->readNumEntry("ImageLoading",SV_IMAGE_LOADING) != IL_ON_USE) return;
	if (!(which & _usedGamePixmaps)) return; // not loaded
	switch(which) {
	case GP_BIGLOGO: delete _bigLogoPxm; _bigLogoPxm = NULL; break;
	case GP_PAUSE: delete _pausePxm; _pausePxm = NULL; break;
	case GP_WIN: delete _winPxm; _winPxm = NULL; break;
	case GP_LOSE: delete _losePxm; _losePxm = NULL; break;
	case GP_LOGO: delete _logoPxm; _logoPxm = NULL; break;
	case GP_BACKGROUND: delete _backgroundPxm; _backgroundPxm = NULL; break;
	default: fatal("Terrible error in KPuzzleView::useGamePixmap");
	}
	_usedGamePixmaps &= ~which;
}

void KPuzzleView::createPlayground(KPuzzleApp* g,bool unbearable)
{
//        ASSERT(game());
	_gameWidget = new KGameWidget(this);
        _gameWidget->setApp(g);
	_gameWidget->setGeometry(50,100,VISIBLE_PIXMAP_SIZE,
				 VISIBLE_PIXMAP_SIZE);
	_bLeft = new QPushButton("<",this);
	_bLeft->setGeometry(20,100,20,VISIBLE_PIXMAP_SIZE);
	_bUp = new QPushButton(i18n("Up"),this);
	_bUp->setGeometry(50,70,VISIBLE_PIXMAP_SIZE,20);
	_bRight = new QPushButton(">",this);
	_bRight->setGeometry(510,100,20,VISIBLE_PIXMAP_SIZE);
	_bDown = new QPushButton(i18n("Down"),this);
	_bDown->setGeometry(50,560,VISIBLE_PIXMAP_SIZE,20);

	_gameWidget->show();
	_bLeft->show();
	_bRight->show();
	_bUp->show();
	_bDown->show();

	connect(_bLeft,SIGNAL(pressed()),_gameWidget,SLOT(slotLeftPress()));
	connect(_bLeft,SIGNAL(released()),_gameWidget,SLOT(slotLeftRelease()));
	connect(_bRight,SIGNAL(pressed()),_gameWidget,SLOT(slotRightPress()));
	connect(_bRight,SIGNAL(released()),_gameWidget,
		SLOT(slotRightRelease()));
	connect(_bUp,SIGNAL(pressed()),_gameWidget,SLOT(slotUpPress()));
	connect(_bUp,SIGNAL(released()),_gameWidget,SLOT(slotUpRelease()));
	connect(_bDown,SIGNAL(pressed()),_gameWidget,SLOT(slotDownPress()));
	connect(_bDown,SIGNAL(released()),_gameWidget,SLOT(slotDownRelease()));

	_pieceWidget = new CPieceWidget(this);
        _pieceWidget->setApp(g);
	_pieceWidget->setGeometry(575,385,200,165);
	_bPrevPiece = new QPushButton(i18n("Previous"),this);
	_bPrevPiece->setGeometry(575,355,200,20);
	_bNextPiece = new QPushButton(i18n("Next"),this);
	_bNextPiece->setGeometry(575,561,200,20);
	_bTurn1 = new QPushButton("<",this);
	_bTurn1->setGeometry(545,385,20,80);
	_bTurn2 = new QPushButton(">",this);
	_bTurn2->setGeometry(545,470,20,80);

	_pieceWidget->show();
	_bPrevPiece->show();
	_bNextPiece->show();
	if (unbearable) {
		_bPrevPiece->setEnabled(false);
		_bNextPiece->setEnabled(false);
	}
	_bTurn1->show();
	_bTurn2->show();

	connect(_bNextPiece,SIGNAL(clicked()),_pieceWidget,
		SLOT(slotNextClicked()));
	connect(_bPrevPiece,SIGNAL(clicked()),_pieceWidget,
		SLOT(slotPrevClicked()));
	connect(_bTurn1,SIGNAL(clicked()),_pieceWidget,
		SLOT(slotTurn1Clicked()));
	connect(_bTurn2,SIGNAL(clicked()),_pieceWidget,
		SLOT(slotTurn2Clicked()));

	_picview = new CPicview(this);
//	_picview->setGeometry(625,125,150,100);
        _picview->setGeometry(634,125,132,99);
	_picview->show();

	_fullview = new CPicview(this);
//	_fullview->setGeometry(625,240,150,100);
        _fullview->setGeometry(634,240,132,99);
	_fullview->show();

	connect(_picview,SIGNAL(sigChangeViewPos(QPoint)),_gameWidget,
		SLOT(slotShowAt(QPoint)));
	connect(_picview,SIGNAL(sigChangeViewPos(QPoint)),_fullview,
		SLOT(slotChangeViewPos(QPoint)));

	connect(_fullview,SIGNAL(sigChangeViewPos(QPoint)),_gameWidget,
		SLOT(slotShowAt(QPoint)));
	connect(_fullview,SIGNAL(sigChangeViewPos(QPoint)),_picview,
		SLOT(slotChangeViewPos(QPoint)));

	connect(_gameWidget,SIGNAL(sigShowAt(QPoint)),_picview,
		SLOT(slotChangeViewPos(QPoint)));
	connect(_gameWidget,SIGNAL(sigShowAt(QPoint)),_fullview,
		SLOT(slotChangeViewPos(QPoint)));

	_score = new QLCDNumber(4,this);
	_score->setGeometry(634,15,84,40);
	_score->show();

	_time = new QLCDNumber(6,this);
	_time->setGeometry(634,70,84,40);
	_time->show();
//	connect(game(),SIGNAL(sigTime(const char*)),_time,
//		SLOT(display(const char*)));


	//	game()->setStatus(GS_RUNNING);

	//	update();
	useGamePixmap(GP_BACKGROUND);
	setBackgroundPixmap(*_backgroundPxm);
}

void KPuzzleView::destroyPlayground()
{
	delete _gameWidget;
	delete _bLeft;
	delete _bRight;
	delete _bUp;
	delete _bDown;
	delete _pieceWidget;
	delete _bPrevPiece;
	delete _bNextPiece;
	delete _bTurn1;
	delete _bTurn2;
	delete _picview;
	delete _fullview;
	delete _score;
	delete _time;

	if (_largePxm) delete _largePxm;
	_largePxm = NULL;
	setBackgroundMode(NoBackground);
	freeGamePixmap(GP_BACKGROUND);
	useGamePixmap(GP_BIGLOGO);
}

#define SHOWW(w) if (s) w->show(); else w->hide();

void KPuzzleView::showAll(bool s)
{
	SHOWW(_gameWidget);
	SHOWW(_bLeft);
	SHOWW(_bUp);
	SHOWW(_bRight);
	SHOWW(_bDown);
	SHOWW(_pieceWidget);
	SHOWW(_bPrevPiece);
	SHOWW(_bNextPiece);
	SHOWW(_bTurn1);
	SHOWW(_bTurn2);
	SHOWW(_picview);
	SHOWW(_fullview);
	SHOWW(_score);
	SHOWW(_time);
}

#undef SHOWW

void KPuzzleView::showBackground(bool s)
{
        if(s) {
                useGamePixmap(GP_BACKGROUND);
                setBackgroundPixmap(*_backgroundPxm);
        } else {
                setBackgroundMode(PaletteDark);
        }
}

void KPuzzleView::enableMenuItems(int enable)
{
        debug("enableMenuItems called!!!");
        actSave()->setEnabled(enable & MI_SAVE_GAME);
        actSaveAs()->setEnabled(enable & MI_SAVE_GAME);

        actTerminate()->setEnabled(enable & MI_STOP_GAME);
        actShowLarge()->setEnabled(enable & MI_SHOW_LARGE);
        actShowMainPixmap()->setEnabled((enable & MI_SHOW_LARGE) &&
                          kapp->sessionConfig()->readBoolEntry("ShowMainPixmap",SV_SHOW_MAIN_PIXMAP));
        actPause()->setEnabled(enable & MI_SHOW_LARGE);
}

void KPuzzleView::updateButtons(bool b1,bool b2,bool b3,bool b4)
{
	_bLeft->setEnabled(b1);
	if (!b1 && gameWidget()->moveKeyPressed() == 1) gameWidget()->slotLeftRelease();
	_bUp->setEnabled(b2);
	if (!b2 && gameWidget()->moveKeyPressed() == 2) gameWidget()->slotUpRelease();
	_bRight->setEnabled(b3);
	if (!b3 && gameWidget()->moveKeyPressed() == 3) gameWidget()->slotRightRelease();
	_bDown->setEnabled(b4);
	if (!b4 && gameWidget()->moveKeyPressed() == 4) gameWidget()->slotDownRelease();
}


void KPuzzleView::resetAll()
{
        _gameWidget->slotShowAt(QPoint(0,0));
        _picview->slotChangeViewPos(QPoint(0,0));
        _fullview->slotChangeViewPos(QPoint(0,0));

}

void KPuzzleView::paintEvent(QPaintEvent*)
{
	switch (status()) {
	case GS_NOT_STARTED:
		if (_bigLogoPxm != NULL) {
			if (_bigLogoPxm->isNull()) debug ("biglogo is null");
			useGamePixmap(GP_BIGLOGO);
			if (_bigLogoPxm->isNull()) debug ("biglogo is STILL null");
			bitBlt(this,QPoint(0,0),_bigLogoPxm,
			       _bigLogoPxm->rect(),CopyROP,false);
			debug("bitblting");
		}
		return;
	case GS_SHOW_LARGE:
	case GS_SHOW_LARGE_WINNING:
	case GS_SHOW_LARGE_LOSING:
		bitBlt(this,QPoint(0,0),_largePxm,
		       _largePxm->rect(),CopyROP,false);
		return;
	case GS_WINNING:
		ASSERT(_winPxm);
		bitBlt(this,QPoint(0,0),_winPxm,_winPxm->rect(),CopyROP,false);
		return;
	case GS_LOSING:
		ASSERT(_losePxm);
		bitBlt(this,QPoint(0,0),_losePxm,_losePxm->rect(),CopyROP,false);
		return;
	case GS_PAUSED:
		ASSERT(_pausePxm != NULL);
		bitBlt(this,QPoint(0,0),_pausePxm,_pausePxm->rect(),CopyROP,false);
		return;
	case GS_SHOW_HIGHSCORES:
		ASSERT(_largePxm);
		bitBlt(this,QPoint(0,0),_largePxm,
		       _largePxm->rect(),CopyROP,false);
		return;
	}

/*	if (status() == GS_NOT_STARTED) return;

	QPainter pt(this);

	QPen redPen(red,2,SolidLine);
	pt.setPen(redPen);
	pt.moveTo(45,555);
	pt.lineTo(45,95);
	pt.lineTo(505,95);
	pt.moveTo(47,553);
	pt.lineTo(503,553);
	pt.lineTo(503,97);

	QPen dRedPen(darkRed,2,SolidLine);
	pt.setPen(dRedPen);
	pt.moveTo(47,553);
	pt.lineTo(47,97);
	pt.lineTo(503,97);
	pt.moveTo(45,555);
	pt.lineTo(505,555);
	pt.lineTo(505,95);

	QPen yellowPen(yellow,2,SolidLine);
	pt.setPen(yellowPen);
	pt.drawLine(537,0,537,599);

	QPen dYellowPen(darkYellow,2,SolidLine);
	pt.setPen(dYellowPen);
	pt.drawLine(540,0,540,599);*/
}

void KPuzzleView::mousePressEvent(QMouseEvent* e)
{
	switch (status()) {
	case GS_PAUSED:
		game()->pause(false);
		update();
		break;
	case GS_SHOW_LARGE:
		game()->pause(false);
		delete _largePxm;
		_largePxm = NULL;
		update();
		break;
	case GS_SHOW_LARGE_WINNING:
		game()->setStatus(GS_SHOW_HIGHSCORES);
		update();
		break;
	case GS_SHOW_LARGE_LOSING:
		game()->setStatus(GS_SHOW_HIGHSCORES);
		update();
		break;
	case GS_LOSING:
		game()->setStatus(GS_SHOW_LARGE_LOSING);
		update();
		break;
	case GS_WINNING:
		game()->setStatus(GS_SHOW_LARGE_WINNING);
		update();
		break;
// 	case GS_SHOW_HIGHSCORES:
// 		delete _largePxm;
// 		_largePxm = NULL;
// 		game()->setStatus(GS_NOT_STARTED);
// 		destroyPlayground();
// 		useGamePixmap(GP_BIGLOGO);
// 		update();
// 		break;
	default:
		QWidget::mousePressEvent(e);
		break;
	}
}

KPuzzleApp* KPuzzleView::createNewGame()
{
        KPuzzleApp* ng = new KPuzzleApp(this);
        if (!ng->createNewGame()) {
                delete ng;
                return NULL;
        }
        return ng;
}

KPuzzleApp* KPuzzleView::createLoadedGame()
{
        KPuzzleApp* ng = new KPuzzleApp(this);
        if (!ng->createLoadedGame()) {
                delete ng;
                return NULL;
        }
        return ng;
}

void KPuzzleView::switchCurrentGame(KPuzzleApp* ng)
{
        ASSERT(ng);
	useGamePixmap(GP_BACKGROUND);
	setBackgroundPixmap(*_backgroundPxm);
        if (_game) delete _game; // disconnects everything
//        else createPlayground(ng->gameData()->_gameType == UNBEARABLE_GAME);
        pieceWidget()->setApp(ng);
        gameWidget()->setApp(ng);
        // connect everything
        connect(actSave(),SIGNAL(activated()),ng,SLOT(slotSaveGame()));
        connect(actSaveAs(),SIGNAL(activated()),ng,SLOT(slotSaveGameAs()));
        connect(actTerminate(),SIGNAL(activated()),ng,SLOT(slotStopGame()));
        connect(actShowLarge(),SIGNAL(activated()),ng,SLOT(slotShowLarge()));
        connect(actShowMainPixmap(),SIGNAL(activated()),ng,SLOT(slotShowMainPixmap()));
        connect(actPause(),SIGNAL(activated()),ng,SLOT(slotPause()));
//        connect(actHighscores(),SIGNAL(activated()),ng,SLOT(slotHighscores()));

        connect(ng,SIGNAL(sigUpdate()),this,SLOT(update()));
	connect(ng,SIGNAL(sigTerm(int)),this,SLOT(slotTerm(int)));
	connect(ng,SIGNAL(sigDone()),this,SLOT(slotGameIsDone()));
	connect(ng,SIGNAL(sigScore(int)),_score,SLOT(display(int)));

        setLargePxm(NULL);
        _picview->updatePixmap(ng->gamePixmap(),_picview->rect());
        _fullview->updatePixmap(ng->mainPixmap(),_fullview->rect());
	_score->display(ng->currentData()->_score);
	_time->display(ng->currentData()->_elapsed);

        _game = ng;

        showAll(true);
        resetAll();
        update();
}

void KPuzzleView::slotNewGame()
{
        bool gameIsPaused = false;
        if (game()) {
                gameIsPaused = game()->paused();
                game()->pause(true);
                if (status() != GS_NOT_STARTED)
                        if (KMessageBox::warningYesNo(0,i18n("A game is already running. Start a new one or return to the current?"),
                                                      i18n("Stop this game?"),i18n("New Game"),i18n("Return")) == KMessageBox::No) {
                                game()->pause(gameIsPaused);
                                return;
                }
        }

        KPuzzleApp* newGame = createNewGame();
        if (!newGame) {
                if (game()) game()->pause(gameIsPaused);
                return;
        }

        if (!game()) createPlayground(newGame,newGame->gameData()->_gameType == UNBEARABLE_GAME);
        newGame->initializeNew();

        switchCurrentGame(newGame); // destroys the old game
        update();
}

void KPuzzleView::slotOpenGame()
{
        bool gameIsPaused = false;
        if (game()) {
                gameIsPaused = game()->paused();
                game()->pause(true);
                if (status() != GS_NOT_STARTED)
                        if (KMessageBox::warningYesNo(0,i18n("A game is already running. Load a new one or return to the current?"),
                                                               i18n("Load game?"),i18n("Load new"),i18n("Return")) == KMessageBox::No) {
                                game()->pause(gameIsPaused);
                        return;
                }
        }

        KPuzzleApp* newGame = createLoadedGame();
        if (!newGame) {
                if (game()) game()->pause(gameIsPaused);
                return;
        }

        if (!game()) createPlayground(newGame,newGame->gameData()->_gameType == UNBEARABLE_GAME);
        newGame->initializeLoad();

        switchCurrentGame(newGame); // destroys the old game
        update();

/*        bool gameIsPaused = paused();
        pause(true);
	if (status() != GS_NOT_STARTED)
		if (KMessageBox::warningContinueCancel(0,i18n("A game is already running. Stop it and open a saved game?"),
                                                       i18n("Stop this game?"),i18n("Continue")) == KMessageBox::Cancel) {
                        pause(gameIsPaused);
                        return;
                }
	gameFilename() = KFileDialog::getOpenFileName(QDir::homeDirPath(),"*.pzz",mainWidget(),i18n("Open Game"));
	if (gameFilename().isNull()) {
                pause(gameIsPaused);
                return;
        }
        if (gameFilename().findRev(".") <= gameFilename().findRev("/")) // There is no dot after the last slash
                gameFilename() += ".pzz";
        if (!QFile::exists(gameFilename())) {
                KMessageBox::sorry(0,i18n("The file you specified does not exist"),i18n("File does not exist"));
                pause(gameIsPaused);
                return;
        }
        QFile file(gameFilename());
        if (!file.open(IO_ReadOnly)) {
                KMessageBox::sorry(0,i18n("The file you specified could not be opened for reading. Check the file's permissions."),
                                   i18n("File could not be opened"));
                pause(gameIsPaused);
                return;
        }

        QDataStream stream(&file);
//        stream.setPrintableData(true);
        if (!load(&stream)) return;
	mainWidget()->createPlayground(gameData()->_gameType == UNBEARABLE_GAME);
        initializeLoad();*/
}

void KPuzzleView::slotTerm(int)
{

}

void KPuzzleView::slotGameIsDone()
{
        destroyPlayground();
        delete _game;
        _game = NULL;
	setBackgroundMode(NoBackground);
	freeGamePixmap(GP_BACKGROUND);
}

void KPuzzleView::slotLoadBackgroundPixmap()
{
	debug("Loading everything");
	useGamePixmap(GP_BIGLOGO);
	repaint(false);
	useGamePixmap(GP_LOGO);
	useGamePixmap(GP_WIN);
	useGamePixmap(GP_LOSE);
	useGamePixmap(GP_PAUSE);
	useGamePixmap(GP_BACKGROUND);
}

